// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class EnsembleConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.Ensemble>
{
	private static readonly System.Text.Json.JsonEncodedText PropAggregateOutput = System.Text.Json.JsonEncodedText.Encode("aggregate_output");
	private static readonly System.Text.Json.JsonEncodedText PropClassificationLabels = System.Text.Json.JsonEncodedText.Encode("classification_labels");
	private static readonly System.Text.Json.JsonEncodedText PropFeatureNames = System.Text.Json.JsonEncodedText.Encode("feature_names");
	private static readonly System.Text.Json.JsonEncodedText PropTargetType = System.Text.Json.JsonEncodedText.Encode("target_type");
	private static readonly System.Text.Json.JsonEncodedText PropTrainedModels = System.Text.Json.JsonEncodedText.Encode("trained_models");

	public override Elastic.Clients.Elasticsearch.MachineLearning.Ensemble Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput?> propAggregateOutput = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propClassificationLabels = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propFeatureNames = default;
		LocalJsonValue<string?> propTargetType = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel>> propTrainedModels = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAggregateOutput.TryReadProperty(ref reader, options, PropAggregateOutput, null))
			{
				continue;
			}

			if (propClassificationLabels.TryReadProperty(ref reader, options, PropClassificationLabels, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propFeatureNames.TryReadProperty(ref reader, options, PropFeatureNames, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propTargetType.TryReadProperty(ref reader, options, PropTargetType, null))
			{
				continue;
			}

			if (propTrainedModels.TryReadProperty(ref reader, options, PropTrainedModels, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel>(o, null)!))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.Ensemble(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AggregateOutput = propAggregateOutput.Value,
			ClassificationLabels = propClassificationLabels.Value,
			FeatureNames = propFeatureNames.Value,
			TargetType = propTargetType.Value,
			TrainedModels = propTrainedModels.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.Ensemble value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAggregateOutput, value.AggregateOutput, null, null);
		writer.WriteProperty(options, PropClassificationLabels, value.ClassificationLabels, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropFeatureNames, value.FeatureNames, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropTargetType, value.TargetType, null, null);
		writer.WriteProperty(options, PropTrainedModels, value.TrainedModels, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel>(o, v, null));
		writer.WriteEndObject();
	}
}