// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DetectorUpdateConverter))]
public sealed partial class DetectorUpdate
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectorUpdate(int detectorIndex)
	{
		DetectorIndex = detectorIndex;
	}
#if NET7_0_OR_GREATER
	public DetectorUpdate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DetectorUpdate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DetectorUpdate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>? CustomRules { get; set; }

	/// <summary>
	/// <para>
	/// A description of the detector.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// A unique identifier for the detector.
	/// This identifier is based on the order of the detectors in the <c>analysis_config</c>, starting at zero.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int DetectorIndex { get; set; }
}

public readonly partial struct DetectorUpdateDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectorUpdateDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectorUpdateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument> CustomRules(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>? value)
	{
		Instance.CustomRules = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument> CustomRules(params Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule[] values)
	{
		Instance.CustomRules = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument> CustomRules(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument>>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument>.Build(action));
		}

		Instance.CustomRules = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the detector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A unique identifier for the detector.
	/// This identifier is based on the order of the detectors in the <c>analysis_config</c>, starting at zero.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument> DetectorIndex(int value)
	{
		Instance.DetectorIndex = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DetectorUpdateDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectorUpdateDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectorUpdateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor CustomRules(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>? value)
	{
		Instance.CustomRules = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor CustomRules(params Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule[] values)
	{
		Instance.CustomRules = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor CustomRules(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor.Build(action));
		}

		Instance.CustomRules = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor CustomRules<T>(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<T>>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<T>.Build(action));
		}

		Instance.CustomRules = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the detector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A unique identifier for the detector.
	/// This identifier is based on the order of the detectors in the <c>analysis_config</c>, starting at zero.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor DetectorIndex(int value)
	{
		Instance.DetectorIndex = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}