// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DetectorReadConverter))]
public sealed partial class DetectorRead
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectorRead(string function)
	{
		Function = function;
	}
#if NET7_0_OR_GREATER
	public DetectorRead()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DetectorRead()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DetectorRead(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field used to split the data.
	/// In particular, this property is used for analyzing the splits with respect to their own history.
	/// It is used for finding unusual values in the context of the split.
	/// </para>
	/// </summary>
	public string? ByFieldName { get; set; }

	/// <summary>
	/// <para>
	/// An array of custom rule objects, which enable you to customize the way detectors operate.
	/// For example, a rule may dictate to the detector conditions under which results should be skipped.
	/// Kibana refers to custom rules as job rules.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>? CustomRules { get; set; }

	/// <summary>
	/// <para>
	/// A description of the detector.
	/// </para>
	/// </summary>
	public string? DetectorDescription { get; set; }

	/// <summary>
	/// <para>
	/// A unique identifier for the detector.
	/// This identifier is based on the order of the detectors in the <c>analysis_config</c>, starting at zero.
	/// </para>
	/// </summary>
	public int? DetectorIndex { get; set; }

	/// <summary>
	/// <para>
	/// Contains one of the following values: <c>all</c>, <c>none</c>, <c>by</c>, or <c>over</c>.
	/// If set, frequent entities are excluded from influencing the anomaly results.
	/// Entities can be considered frequent over time or frequent in a population.
	/// If you are working with both over and by fields, then you can set <c>exclude_frequent</c> to all for both fields, or to <c>by</c> or <c>over</c> for those specific fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent? ExcludeFrequent { get; set; }

	/// <summary>
	/// <para>
	/// The field that the detector uses in the function.
	/// If you use an event rate function such as <c>count</c> or <c>rare</c>, do not specify this field.
	/// </para>
	/// </summary>
	public string? FieldName { get; set; }

	/// <summary>
	/// <para>
	/// The analysis function that is used.
	/// For example, <c>count</c>, <c>rare</c>, <c>mean</c>, <c>min</c>, <c>max</c>, and <c>sum</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Function { get; set; }

	/// <summary>
	/// <para>
	/// The field used to split the data.
	/// In particular, this property is used for analyzing the splits with respect to the history of all splits.
	/// It is used for finding unusual values in the population of all splits.
	/// </para>
	/// </summary>
	public string? OverFieldName { get; set; }

	/// <summary>
	/// <para>
	/// The field used to segment the analysis.
	/// When you use this property, you have completely independent baselines for each value of this field.
	/// </para>
	/// </summary>
	public string? PartitionFieldName { get; set; }

	/// <summary>
	/// <para>
	/// Defines whether a new series is used as the null series when there is no value for the by or partition fields.
	/// </para>
	/// </summary>
	public bool? UseNull { get; set; }
}