// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DetectorReadConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead>
{
	private static readonly System.Text.Json.JsonEncodedText PropByFieldName = System.Text.Json.JsonEncodedText.Encode("by_field_name");
	private static readonly System.Text.Json.JsonEncodedText PropCustomRules = System.Text.Json.JsonEncodedText.Encode("custom_rules");
	private static readonly System.Text.Json.JsonEncodedText PropDetectorDescription = System.Text.Json.JsonEncodedText.Encode("detector_description");
	private static readonly System.Text.Json.JsonEncodedText PropDetectorIndex = System.Text.Json.JsonEncodedText.Encode("detector_index");
	private static readonly System.Text.Json.JsonEncodedText PropExcludeFrequent = System.Text.Json.JsonEncodedText.Encode("exclude_frequent");
	private static readonly System.Text.Json.JsonEncodedText PropFieldName = System.Text.Json.JsonEncodedText.Encode("field_name");
	private static readonly System.Text.Json.JsonEncodedText PropFunction = System.Text.Json.JsonEncodedText.Encode("function");
	private static readonly System.Text.Json.JsonEncodedText PropOverFieldName = System.Text.Json.JsonEncodedText.Encode("over_field_name");
	private static readonly System.Text.Json.JsonEncodedText PropPartitionFieldName = System.Text.Json.JsonEncodedText.Encode("partition_field_name");
	private static readonly System.Text.Json.JsonEncodedText PropUseNull = System.Text.Json.JsonEncodedText.Encode("use_null");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propByFieldName = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>?> propCustomRules = default;
		LocalJsonValue<string?> propDetectorDescription = default;
		LocalJsonValue<int?> propDetectorIndex = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent?> propExcludeFrequent = default;
		LocalJsonValue<string?> propFieldName = default;
		LocalJsonValue<string> propFunction = default;
		LocalJsonValue<string?> propOverFieldName = default;
		LocalJsonValue<string?> propPartitionFieldName = default;
		LocalJsonValue<bool?> propUseNull = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propByFieldName.TryReadProperty(ref reader, options, PropByFieldName, null))
			{
				continue;
			}

			if (propCustomRules.TryReadProperty(ref reader, options, PropCustomRules, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>(o, null)))
			{
				continue;
			}

			if (propDetectorDescription.TryReadProperty(ref reader, options, PropDetectorDescription, null))
			{
				continue;
			}

			if (propDetectorIndex.TryReadProperty(ref reader, options, PropDetectorIndex, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propExcludeFrequent.TryReadProperty(ref reader, options, PropExcludeFrequent, static Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent>(o)))
			{
				continue;
			}

			if (propFieldName.TryReadProperty(ref reader, options, PropFieldName, null))
			{
				continue;
			}

			if (propFunction.TryReadProperty(ref reader, options, PropFunction, null))
			{
				continue;
			}

			if (propOverFieldName.TryReadProperty(ref reader, options, PropOverFieldName, null))
			{
				continue;
			}

			if (propPartitionFieldName.TryReadProperty(ref reader, options, PropPartitionFieldName, null))
			{
				continue;
			}

			if (propUseNull.TryReadProperty(ref reader, options, PropUseNull, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ByFieldName = propByFieldName.Value,
			CustomRules = propCustomRules.Value,
			DetectorDescription = propDetectorDescription.Value,
			DetectorIndex = propDetectorIndex.Value,
			ExcludeFrequent = propExcludeFrequent.Value,
			FieldName = propFieldName.Value,
			Function = propFunction.Value,
			OverFieldName = propOverFieldName.Value,
			PartitionFieldName = propPartitionFieldName.Value,
			UseNull = propUseNull.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropByFieldName, value.ByFieldName, null, null);
		writer.WriteProperty(options, PropCustomRules, value.CustomRules, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule>(o, v, null));
		writer.WriteProperty(options, PropDetectorDescription, value.DetectorDescription, null, null);
		writer.WriteProperty(options, PropDetectorIndex, value.DetectorIndex, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropExcludeFrequent, value.ExcludeFrequent, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent>(o, v));
		writer.WriteProperty(options, PropFieldName, value.FieldName, null, null);
		writer.WriteProperty(options, PropFunction, value.Function, null, null);
		writer.WriteProperty(options, PropOverFieldName, value.OverFieldName, null, null);
		writer.WriteProperty(options, PropPartitionFieldName, value.PartitionFieldName, null, null);
		writer.WriteProperty(options, PropUseNull, value.UseNull, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteEndObject();
	}
}