// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DetectionRuleConverter))]
public sealed partial class DetectionRule
{
#if NET7_0_OR_GREATER
	public DetectionRule()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DetectionRule()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The set of actions to be triggered when the rule applies. If more than one action is specified the effects of all actions are combined.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.RuleAction>? Actions { get; set; }

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition>? Conditions { get; set; }

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>? Scope { get; set; }
}

public readonly partial struct DetectionRuleDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectionRuleDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectionRuleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The set of actions to be triggered when the rule applies. If more than one action is specified the effects of all actions are combined.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Actions(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.RuleAction>? value)
	{
		Instance.Actions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The set of actions to be triggered when the rule applies. If more than one action is specified the effects of all actions are combined.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Actions(params Elastic.Clients.Elasticsearch.MachineLearning.RuleAction[] values)
	{
		Instance.Actions = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Conditions(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition>? value)
	{
		Instance.Conditions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Conditions(params Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition[] values)
	{
		Instance.Conditions = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Conditions(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor.Build(action));
		}

		Instance.Conditions = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Scope(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>? value)
	{
		Instance.Scope = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Scope()
	{
		Instance.Scope = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> Scope(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef<TDocument>>? action)
	{
		Instance.Scope = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> AddScope(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef value)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> AddScope(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef value)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> AddScope(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor> action)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument> AddScope(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor> action)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DetectionRuleDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectionRuleDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetectionRuleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The set of actions to be triggered when the rule applies. If more than one action is specified the effects of all actions are combined.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Actions(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.RuleAction>? value)
	{
		Instance.Actions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The set of actions to be triggered when the rule applies. If more than one action is specified the effects of all actions are combined.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Actions(params Elastic.Clients.Elasticsearch.MachineLearning.RuleAction[] values)
	{
		Instance.Actions = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Conditions(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition>? value)
	{
		Instance.Conditions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Conditions(params Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition[] values)
	{
		Instance.Conditions = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Conditions(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor.Build(action));
		}

		Instance.Conditions = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Scope(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>? value)
	{
		Instance.Scope = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Scope()
	{
		Instance.Scope = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Scope(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef>? action)
	{
		Instance.Scope = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor Scope<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef<T>>? action)
	{
		Instance.Scope = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFilterRef<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor AddScope(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef value)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor AddScope<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef value)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor AddScope(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor> action)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor AddScope<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor> action)
	{
		Instance.Scope ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.MachineLearning.FilterRef>();
		Instance.Scope.Add(key, Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRuleDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DetectionRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}