// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DeploymentAssignmentStateConverter))]
public enum DeploymentAssignmentState
{
	/// <summary>
	/// <para>
	/// The deployment is on a failed state and must be re-deployed.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "failed")]
	Failed,
	/// <summary>
	/// <para>
	/// The deployment is usable; at least one node has the model allocated.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "started")]
	Started,
	/// <summary>
	/// <para>
	/// The deployment has recently started but is not yet usable; the model is not allocated on any nodes.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "starting")]
	Starting,
	/// <summary>
	/// <para>
	/// The deployment is preparing to stop and deallocate the model from the relevant nodes.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "stopping")]
	Stopping
}