// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DeploymentAllocationStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFullyAllocated = System.Text.Json.JsonEncodedText.Encode("fully_allocated");
	private static readonly System.Text.Json.JsonEncodedText MemberStarted = System.Text.Json.JsonEncodedText.Encode("started");
	private static readonly System.Text.Json.JsonEncodedText MemberStarting = System.Text.Json.JsonEncodedText.Encode("starting");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFullyAllocated))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.FullyAllocated;
		}

		if (reader.ValueTextEquals(MemberStarted))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.Started;
		}

		if (reader.ValueTextEquals(MemberStarting))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.Starting;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFullyAllocated.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.FullyAllocated;
		}

		if (string.Equals(value, MemberStarted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.Started;
		}

		if (string.Equals(value, MemberStarting.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.Starting;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.FullyAllocated:
				writer.WriteStringValue(MemberFullyAllocated);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.Started:
				writer.WriteStringValue(MemberStarted);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState.Starting:
				writer.WriteStringValue(MemberStarting);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAllocationState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}