// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DataframeRegressionSummaryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DataframeRegressionSummary>
{
	private static readonly System.Text.Json.JsonEncodedText PropHuber = System.Text.Json.JsonEncodedText.Encode("huber");
	private static readonly System.Text.Json.JsonEncodedText PropMse = System.Text.Json.JsonEncodedText.Encode("mse");
	private static readonly System.Text.Json.JsonEncodedText PropMsle = System.Text.Json.JsonEncodedText.Encode("msle");
	private static readonly System.Text.Json.JsonEncodedText PropRSquared = System.Text.Json.JsonEncodedText.Encode("r_squared");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DataframeRegressionSummary Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationValue?> propHuber = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationValue?> propMse = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationValue?> propMsle = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationValue?> propRSquared = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propHuber.TryReadProperty(ref reader, options, PropHuber, null))
			{
				continue;
			}

			if (propMse.TryReadProperty(ref reader, options, PropMse, null))
			{
				continue;
			}

			if (propMsle.TryReadProperty(ref reader, options, PropMsle, null))
			{
				continue;
			}

			if (propRSquared.TryReadProperty(ref reader, options, PropRSquared, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeRegressionSummary(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Huber = propHuber.Value,
			Mse = propMse.Value,
			Msle = propMsle.Value,
			RSquared = propRSquared.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DataframeRegressionSummary value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropHuber, value.Huber, null, null);
		writer.WriteProperty(options, PropMse, value.Mse, null, null);
		writer.WriteProperty(options, PropMsle, value.Msle, null, null);
		writer.WriteProperty(options, PropRSquared, value.RSquared, null, null);
		writer.WriteEndObject();
	}
}