// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeEvaluationRegressionMetricsConverter))]
public sealed partial class DataframeEvaluationRegressionMetrics
{
#if NET7_0_OR_GREATER
	public DataframeEvaluationRegressionMetrics()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataframeEvaluationRegressionMetrics()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeEvaluationRegressionMetrics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Pseudo Huber loss function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsHuber? Huber { get; set; }

	/// <summary>
	/// <para>
	/// Average squared difference between the predicted values and the actual (ground truth) value. For more information, read this wiki article.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Mse { get; set; }

	/// <summary>
	/// <para>
	/// Average squared difference between the logarithm of the predicted values and the logarithm of the actual (ground truth) value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsMsle? Msle { get; set; }

	/// <summary>
	/// <para>
	/// Proportion of the variance in the dependent variable that is predictable from the independent variables.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? RSquared { get; set; }
}

public readonly partial struct DataframeEvaluationRegressionMetricsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegressionMetricsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegressionMetricsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Pseudo Huber loss function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Huber(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsHuber? value)
	{
		Instance.Huber = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Pseudo Huber loss function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Huber()
	{
		Instance.Huber = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsHuberDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pseudo Huber loss function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Huber(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsHuberDescriptor>? action)
	{
		Instance.Huber = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsHuberDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Average squared difference between the predicted values and the actual (ground truth) value. For more information, read this wiki article.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Mse(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Mse = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Average squared difference between the predicted values and the actual (ground truth) value. For more information, read this wiki article.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Mse()
	{
		Instance.Mse = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Average squared difference between the predicted values and the actual (ground truth) value. For more information, read this wiki article.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Mse(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Mse = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor AddMse(string key, object value)
	{
		Instance.Mse ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Mse.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Average squared difference between the logarithm of the predicted values and the logarithm of the actual (ground truth) value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Msle(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsMsle? value)
	{
		Instance.Msle = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Average squared difference between the logarithm of the predicted values and the logarithm of the actual (ground truth) value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Msle()
	{
		Instance.Msle = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsMsleDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Average squared difference between the logarithm of the predicted values and the logarithm of the actual (ground truth) value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor Msle(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsMsleDescriptor>? action)
	{
		Instance.Msle = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsMsleDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Proportion of the variance in the dependent variable that is predictable from the independent variables.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor RSquared(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.RSquared = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Proportion of the variance in the dependent variable that is predictable from the independent variables.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor RSquared()
	{
		Instance.RSquared = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Proportion of the variance in the dependent variable that is predictable from the independent variables.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor RSquared(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.RSquared = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor AddRSquared(string key, object value)
	{
		Instance.RSquared ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.RSquared.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}