// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeEvaluationRegressionConverter))]
public sealed partial class DataframeEvaluationRegression
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.Field actualField, Elastic.Clients.Elasticsearch.Field predictedField)
	{
		ActualField = actualField;
		PredictedField = predictedField;
	}
#if NET7_0_OR_GREATER
	public DataframeEvaluationRegression()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataframeEvaluationRegression()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field must be numerical.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field ActualField { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics? Metrics { get; set; }

	/// <summary>
	/// <para>
	/// The field in the index that contains the predicted value, in other words the results of the regression analysis.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field PredictedField { get; set; }
}

public readonly partial struct DataframeEvaluationRegressionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegressionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegressionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field must be numerical.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> ActualField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field must be numerical.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> ActualField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> Metrics(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> Metrics()
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> Metrics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor>? action)
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index that contains the predicted value, in other words the results of the regression analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> PredictedField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.PredictedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index that contains the predicted value, in other words the results of the regression analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument> PredictedField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.PredictedField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DataframeEvaluationRegressionDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegressionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationRegressionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field must be numerical.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor ActualField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field must be numerical.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor ActualField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor Metrics(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetrics? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor Metrics()
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation. For more information on mse, msle, and huber, consult the Jupyter notebook on regression loss functions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor Metrics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor>? action)
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionMetricsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index that contains the predicted value, in other words the results of the regression analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor PredictedField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.PredictedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index that contains the predicted value, in other words the results of the regression analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor PredictedField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.PredictedField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}