// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeEvaluationClassificationConverter))]
public sealed partial class DataframeEvaluationClassification
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.Field actualField)
	{
		ActualField = actualField;
	}
#if NET7_0_OR_GREATER
	public DataframeEvaluationClassification()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataframeEvaluationClassification()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field can be boolean or integer. If the data type is integer, the value has to be either 0 (false) or 1 (true).
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field ActualField { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetrics? Metrics { get; set; }

	/// <summary>
	/// <para>
	/// The field in the index which contains the predicted value, in other words the results of the classification analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? PredictedField { get; set; }

	/// <summary>
	/// <para>
	/// The field of the index which is an array of documents of the form { "class_name": XXX, "class_probability": YYY }. This field must be defined as nested in the mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TopClassesField { get; set; }
}

public readonly partial struct DataframeEvaluationClassificationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationClassificationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationClassificationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field can be boolean or integer. If the data type is integer, the value has to be either 0 (false) or 1 (true).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> ActualField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field can be boolean or integer. If the data type is integer, the value has to be either 0 (false) or 1 (true).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> ActualField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> Metrics(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetrics? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> Metrics()
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetricsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> Metrics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetricsDescriptor>? action)
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetricsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index which contains the predicted value, in other words the results of the classification analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> PredictedField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.PredictedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index which contains the predicted value, in other words the results of the classification analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> PredictedField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.PredictedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which is an array of documents of the form { "class_name": XXX, "class_probability": YYY }. This field must be defined as nested in the mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> TopClassesField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TopClassesField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which is an array of documents of the form { "class_name": XXX, "class_probability": YYY }. This field must be defined as nested in the mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument> TopClassesField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TopClassesField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DataframeEvaluationClassificationDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationClassificationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationClassificationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field can be boolean or integer. If the data type is integer, the value has to be either 0 (false) or 1 (true).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor ActualField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which contains the ground truth. The data type of this field can be boolean or integer. If the data type is integer, the value has to be either 0 (false) or 1 (true).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor ActualField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.ActualField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor Metrics(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetrics? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor Metrics()
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetricsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the metrics that are used for the evaluation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor Metrics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetricsDescriptor>? action)
	{
		Instance.Metrics = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationMetricsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index which contains the predicted value, in other words the results of the classification analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor PredictedField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.PredictedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field in the index which contains the predicted value, in other words the results of the classification analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor PredictedField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.PredictedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which is an array of documents of the form { "class_name": XXX, "class_probability": YYY }. This field must be defined as nested in the mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor TopClassesField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TopClassesField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field of the index which is an array of documents of the form { "class_name": XXX, "class_probability": YYY }. This field must be defined as nested in the mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor TopClassesField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TopClassesField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}