// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeEvaluationConverter))]
public sealed partial class DataframeEvaluation
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public DataframeEvaluation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataframeEvaluation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeEvaluation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Classification evaluation evaluates the results of a classification analysis which outputs a prediction that identifies to which of the classes each document belongs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification? Classification { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification>("classification"); set => SetVariant("classification", value); }

	/// <summary>
	/// <para>
	/// Outlier detection evaluates the results of an outlier detection analysis which outputs the probability that each document is an outlier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetection? OutlierDetection { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetection>("outlier_detection"); set => SetVariant("outlier_detection", value); }

	/// <summary>
	/// <para>
	/// Regression evaluation evaluates the results of a regression analysis which outputs a prediction of values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression? Regression { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression>("regression"); set => SetVariant("regression", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification value) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation { Classification = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetection value) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation { OutlierDetection = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression value) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation { Regression = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct DataframeEvaluationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification evaluation evaluates the results of a classification analysis which outputs a prediction that identifies to which of the classes each document belongs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> Classification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification evaluation evaluates the results of a classification analysis which outputs a prediction that identifies to which of the classes each document belongs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> Classification(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument>> action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Outlier detection evaluates the results of an outlier detection analysis which outputs the probability that each document is an outlier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> OutlierDetection(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetection? value)
	{
		Instance.OutlierDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Outlier detection evaluates the results of an outlier detection analysis which outputs the probability that each document is an outlier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> OutlierDetection(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetectionDescriptor<TDocument>> action)
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetectionDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression evaluation evaluates the results of a regression analysis which outputs a prediction of values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> Regression(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression evaluation evaluates the results of a regression analysis which outputs a prediction of values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument> Regression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument>> action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DataframeEvaluationDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeEvaluationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification evaluation evaluates the results of a classification analysis which outputs a prediction that identifies to which of the classes each document belongs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor Classification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassification? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification evaluation evaluates the results of a classification analysis which outputs a prediction that identifies to which of the classes each document belongs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor Classification(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor> action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification evaluation evaluates the results of a classification analysis which outputs a prediction that identifies to which of the classes each document belongs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor Classification<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<T>> action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationClassificationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Outlier detection evaluates the results of an outlier detection analysis which outputs the probability that each document is an outlier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor OutlierDetection(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetection? value)
	{
		Instance.OutlierDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Outlier detection evaluates the results of an outlier detection analysis which outputs the probability that each document is an outlier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor OutlierDetection(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetectionDescriptor> action)
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetectionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Outlier detection evaluates the results of an outlier detection analysis which outputs the probability that each document is an outlier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor OutlierDetection<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetectionDescriptor<T>> action)
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationOutlierDetectionDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression evaluation evaluates the results of a regression analysis which outputs a prediction of values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor Regression(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegression? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression evaluation evaluates the results of a regression analysis which outputs a prediction of values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor Regression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor> action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression evaluation evaluates the results of a regression analysis which outputs a prediction of values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor Regression<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<T>> action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationRegressionDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}