// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DataframeClassificationSummaryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummary>
{
	private static readonly System.Text.Json.JsonEncodedText PropAccuracy = System.Text.Json.JsonEncodedText.Encode("accuracy");
	private static readonly System.Text.Json.JsonEncodedText PropAucRoc = System.Text.Json.JsonEncodedText.Encode("auc_roc");
	private static readonly System.Text.Json.JsonEncodedText PropMulticlassConfusionMatrix = System.Text.Json.JsonEncodedText.Encode("multiclass_confusion_matrix");
	private static readonly System.Text.Json.JsonEncodedText PropPrecision = System.Text.Json.JsonEncodedText.Encode("precision");
	private static readonly System.Text.Json.JsonEncodedText PropRecall = System.Text.Json.JsonEncodedText.Encode("recall");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummary Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummaryAccuracy?> propAccuracy = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationSummaryAucRoc?> propAucRoc = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummaryMulticlassConfusionMatrix?> propMulticlassConfusionMatrix = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummaryPrecision?> propPrecision = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummaryRecall?> propRecall = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAccuracy.TryReadProperty(ref reader, options, PropAccuracy, null))
			{
				continue;
			}

			if (propAucRoc.TryReadProperty(ref reader, options, PropAucRoc, null))
			{
				continue;
			}

			if (propMulticlassConfusionMatrix.TryReadProperty(ref reader, options, PropMulticlassConfusionMatrix, null))
			{
				continue;
			}

			if (propPrecision.TryReadProperty(ref reader, options, PropPrecision, null))
			{
				continue;
			}

			if (propRecall.TryReadProperty(ref reader, options, PropRecall, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummary(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Accuracy = propAccuracy.Value,
			AucRoc = propAucRoc.Value,
			MulticlassConfusionMatrix = propMulticlassConfusionMatrix.Value,
			Precision = propPrecision.Value,
			Recall = propRecall.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DataframeClassificationSummary value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAccuracy, value.Accuracy, null, null);
		writer.WriteProperty(options, PropAucRoc, value.AucRoc, null, null);
		writer.WriteProperty(options, PropMulticlassConfusionMatrix, value.MulticlassConfusionMatrix, null, null);
		writer.WriteProperty(options, PropPrecision, value.Precision, null, null);
		writer.WriteProperty(options, PropRecall, value.Recall, null, null);
		writer.WriteEndObject();
	}
}