// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeAnalyticsStatsMemoryUsageConverter))]
public sealed partial class DataframeAnalyticsStatsMemoryUsage
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalyticsStatsMemoryUsage(long peakUsageBytes, string status)
	{
		PeakUsageBytes = peakUsageBytes;
		Status = status;
	}
#if NET7_0_OR_GREATER
	public DataframeAnalyticsStatsMemoryUsage()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataframeAnalyticsStatsMemoryUsage()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeAnalyticsStatsMemoryUsage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// This value is present when the status is hard_limit and it is a new estimate of how much memory the job needs.
	/// </para>
	/// </summary>
	public long? MemoryReestimateBytes { get; set; }

	/// <summary>
	/// <para>
	/// The number of bytes used at the highest peak of memory usage.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long PeakUsageBytes { get; set; }

	/// <summary>
	/// <para>
	/// The memory usage status.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Status { get; set; }

	/// <summary>
	/// <para>
	/// The timestamp when memory usage was calculated.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Timestamp { get; set; }
}