// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DataframeAnalyticsFieldSelectionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsFieldSelection>
{
	private static readonly System.Text.Json.JsonEncodedText PropFeatureType = System.Text.Json.JsonEncodedText.Encode("feature_type");
	private static readonly System.Text.Json.JsonEncodedText PropIsIncluded = System.Text.Json.JsonEncodedText.Encode("is_included");
	private static readonly System.Text.Json.JsonEncodedText PropIsRequired = System.Text.Json.JsonEncodedText.Encode("is_required");
	private static readonly System.Text.Json.JsonEncodedText PropMappingTypes = System.Text.Json.JsonEncodedText.Encode("mapping_types");
	private static readonly System.Text.Json.JsonEncodedText PropName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText PropReason = System.Text.Json.JsonEncodedText.Encode("reason");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsFieldSelection Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propFeatureType = default;
		LocalJsonValue<bool> propIsIncluded = default;
		LocalJsonValue<bool> propIsRequired = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propMappingTypes = default;
		LocalJsonValue<string> propName = default;
		LocalJsonValue<string?> propReason = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFeatureType.TryReadProperty(ref reader, options, PropFeatureType, null))
			{
				continue;
			}

			if (propIsIncluded.TryReadProperty(ref reader, options, PropIsIncluded, null))
			{
				continue;
			}

			if (propIsRequired.TryReadProperty(ref reader, options, PropIsRequired, null))
			{
				continue;
			}

			if (propMappingTypes.TryReadProperty(ref reader, options, PropMappingTypes, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propName.TryReadProperty(ref reader, options, PropName, null))
			{
				continue;
			}

			if (propReason.TryReadProperty(ref reader, options, PropReason, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsFieldSelection(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FeatureType = propFeatureType.Value,
			IsIncluded = propIsIncluded.Value,
			IsRequired = propIsRequired.Value,
			MappingTypes = propMappingTypes.Value,
			Name = propName.Value,
			Reason = propReason.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsFieldSelection value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFeatureType, value.FeatureType, null, null);
		writer.WriteProperty(options, PropIsIncluded, value.IsIncluded, null, null);
		writer.WriteProperty(options, PropIsRequired, value.IsRequired, null, null);
		writer.WriteProperty(options, PropMappingTypes, value.MappingTypes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropName, value.Name, null, null);
		writer.WriteProperty(options, PropReason, value.Reason, null, null);
		writer.WriteEndObject();
	}
}