// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeAnalyticsConverter))]
public sealed partial class DataframeAnalytics
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsStatsDataCounts dataCounts, string id, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsStatsMemoryUsage memoryUsage, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsStatsProgress> progress, Elastic.Clients.Elasticsearch.MachineLearning.DataframeState state)
	{
		DataCounts = dataCounts;
		Id = id;
		MemoryUsage = memoryUsage;
		Progress = progress;
		State = state;
	}
#if NET7_0_OR_GREATER
	public DataframeAnalytics()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataframeAnalytics()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeAnalytics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For running jobs only, contains messages relating to the selection of a node to run the job.
	/// </para>
	/// </summary>
	public string? AssignmentExplanation { get; set; }

	/// <summary>
	/// <para>
	/// An object that provides counts for the quantity of documents skipped, used in training, or available for testing.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsStatsDataCounts DataCounts { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier of the data frame analytics job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }

	/// <summary>
	/// <para>
	/// An object describing memory usage of the analytics. It is present only after the job is started and memory usage is reported.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsStatsMemoryUsage MemoryUsage { get; set; }

	/// <summary>
	/// <para>
	/// Contains properties for the node that runs the job. This information is available only for running jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.NodeAttributes? Node { get; set; }

	/// <summary>
	/// <para>
	/// The progress report of the data frame analytics job by phase.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsStatsProgress> Progress { get; set; }

	/// <summary>
	/// <para>
	/// The status of the data frame analytics job, which can be one of the following values: failed, started, starting, stopping, stopped.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeState State { get; set; }
}