// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DataframeAnalysisRegressionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression>
{
	private static readonly System.Text.Json.JsonEncodedText PropAlpha = System.Text.Json.JsonEncodedText.Encode("alpha");
	private static readonly System.Text.Json.JsonEncodedText PropDependentVariable = System.Text.Json.JsonEncodedText.Encode("dependent_variable");
	private static readonly System.Text.Json.JsonEncodedText PropDownsampleFactor = System.Text.Json.JsonEncodedText.Encode("downsample_factor");
	private static readonly System.Text.Json.JsonEncodedText PropEarlyStoppingEnabled = System.Text.Json.JsonEncodedText.Encode("early_stopping_enabled");
	private static readonly System.Text.Json.JsonEncodedText PropEta = System.Text.Json.JsonEncodedText.Encode("eta");
	private static readonly System.Text.Json.JsonEncodedText PropEtaGrowthRatePerTree = System.Text.Json.JsonEncodedText.Encode("eta_growth_rate_per_tree");
	private static readonly System.Text.Json.JsonEncodedText PropFeatureBagFraction = System.Text.Json.JsonEncodedText.Encode("feature_bag_fraction");
	private static readonly System.Text.Json.JsonEncodedText PropFeatureProcessors = System.Text.Json.JsonEncodedText.Encode("feature_processors");
	private static readonly System.Text.Json.JsonEncodedText PropGamma = System.Text.Json.JsonEncodedText.Encode("gamma");
	private static readonly System.Text.Json.JsonEncodedText PropLambda = System.Text.Json.JsonEncodedText.Encode("lambda");
	private static readonly System.Text.Json.JsonEncodedText PropLossFunction = System.Text.Json.JsonEncodedText.Encode("loss_function");
	private static readonly System.Text.Json.JsonEncodedText PropLossFunctionParameter = System.Text.Json.JsonEncodedText.Encode("loss_function_parameter");
	private static readonly System.Text.Json.JsonEncodedText PropMaxOptimizationRoundsPerHyperparameter = System.Text.Json.JsonEncodedText.Encode("max_optimization_rounds_per_hyperparameter");
	private static readonly System.Text.Json.JsonEncodedText PropMaxTrees = System.Text.Json.JsonEncodedText.Encode("max_trees");
	private static readonly System.Text.Json.JsonEncodedText PropMaxTrees1 = System.Text.Json.JsonEncodedText.Encode("maximum_number_trees");
	private static readonly System.Text.Json.JsonEncodedText PropNumTopFeatureImportanceValues = System.Text.Json.JsonEncodedText.Encode("num_top_feature_importance_values");
	private static readonly System.Text.Json.JsonEncodedText PropPredictionFieldName = System.Text.Json.JsonEncodedText.Encode("prediction_field_name");
	private static readonly System.Text.Json.JsonEncodedText PropRandomizeSeed = System.Text.Json.JsonEncodedText.Encode("randomize_seed");
	private static readonly System.Text.Json.JsonEncodedText PropSoftTreeDepthLimit = System.Text.Json.JsonEncodedText.Encode("soft_tree_depth_limit");
	private static readonly System.Text.Json.JsonEncodedText PropSoftTreeDepthTolerance = System.Text.Json.JsonEncodedText.Encode("soft_tree_depth_tolerance");
	private static readonly System.Text.Json.JsonEncodedText PropTrainingPercent = System.Text.Json.JsonEncodedText.Encode("training_percent");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<double?> propAlpha = default;
		LocalJsonValue<string> propDependentVariable = default;
		LocalJsonValue<double?> propDownsampleFactor = default;
		LocalJsonValue<bool?> propEarlyStoppingEnabled = default;
		LocalJsonValue<double?> propEta = default;
		LocalJsonValue<double?> propEtaGrowthRatePerTree = default;
		LocalJsonValue<double?> propFeatureBagFraction = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>?> propFeatureProcessors = default;
		LocalJsonValue<double?> propGamma = default;
		LocalJsonValue<double?> propLambda = default;
		LocalJsonValue<string?> propLossFunction = default;
		LocalJsonValue<double?> propLossFunctionParameter = default;
		LocalJsonValue<int?> propMaxOptimizationRoundsPerHyperparameter = default;
		LocalJsonValue<int?> propMaxTrees = default;
		LocalJsonValue<int?> propNumTopFeatureImportanceValues = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propPredictionFieldName = default;
		LocalJsonValue<double?> propRandomizeSeed = default;
		LocalJsonValue<int?> propSoftTreeDepthLimit = default;
		LocalJsonValue<double?> propSoftTreeDepthTolerance = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Percentage?> propTrainingPercent = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAlpha.TryReadProperty(ref reader, options, PropAlpha, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propDependentVariable.TryReadProperty(ref reader, options, PropDependentVariable, null))
			{
				continue;
			}

			if (propDownsampleFactor.TryReadProperty(ref reader, options, PropDownsampleFactor, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propEarlyStoppingEnabled.TryReadProperty(ref reader, options, PropEarlyStoppingEnabled, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propEta.TryReadProperty(ref reader, options, PropEta, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propEtaGrowthRatePerTree.TryReadProperty(ref reader, options, PropEtaGrowthRatePerTree, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propFeatureBagFraction.TryReadProperty(ref reader, options, PropFeatureBagFraction, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propFeatureProcessors.TryReadProperty(ref reader, options, PropFeatureProcessors, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>(o, null)))
			{
				continue;
			}

			if (propGamma.TryReadProperty(ref reader, options, PropGamma, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propLambda.TryReadProperty(ref reader, options, PropLambda, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propLossFunction.TryReadProperty(ref reader, options, PropLossFunction, null))
			{
				continue;
			}

			if (propLossFunctionParameter.TryReadProperty(ref reader, options, PropLossFunctionParameter, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propMaxOptimizationRoundsPerHyperparameter.TryReadProperty(ref reader, options, PropMaxOptimizationRoundsPerHyperparameter, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxTrees.TryReadProperty(ref reader, options, PropMaxTrees, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)) || propMaxTrees.TryReadProperty(ref reader, options, PropMaxTrees1, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNumTopFeatureImportanceValues.TryReadProperty(ref reader, options, PropNumTopFeatureImportanceValues, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propPredictionFieldName.TryReadProperty(ref reader, options, PropPredictionFieldName, null))
			{
				continue;
			}

			if (propRandomizeSeed.TryReadProperty(ref reader, options, PropRandomizeSeed, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propSoftTreeDepthLimit.TryReadProperty(ref reader, options, PropSoftTreeDepthLimit, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSoftTreeDepthTolerance.TryReadProperty(ref reader, options, PropSoftTreeDepthTolerance, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propTrainingPercent.TryReadProperty(ref reader, options, PropTrainingPercent, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Alpha = propAlpha.Value,
			DependentVariable = propDependentVariable.Value,
			DownsampleFactor = propDownsampleFactor.Value,
			EarlyStoppingEnabled = propEarlyStoppingEnabled.Value,
			Eta = propEta.Value,
			EtaGrowthRatePerTree = propEtaGrowthRatePerTree.Value,
			FeatureBagFraction = propFeatureBagFraction.Value,
			FeatureProcessors = propFeatureProcessors.Value,
			Gamma = propGamma.Value,
			Lambda = propLambda.Value,
			LossFunction = propLossFunction.Value,
			LossFunctionParameter = propLossFunctionParameter.Value,
			MaxOptimizationRoundsPerHyperparameter = propMaxOptimizationRoundsPerHyperparameter.Value,
			MaxTrees = propMaxTrees.Value,
			NumTopFeatureImportanceValues = propNumTopFeatureImportanceValues.Value,
			PredictionFieldName = propPredictionFieldName.Value,
			RandomizeSeed = propRandomizeSeed.Value,
			SoftTreeDepthLimit = propSoftTreeDepthLimit.Value,
			SoftTreeDepthTolerance = propSoftTreeDepthTolerance.Value,
			TrainingPercent = propTrainingPercent.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAlpha, value.Alpha, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropDependentVariable, value.DependentVariable, null, null);
		writer.WriteProperty(options, PropDownsampleFactor, value.DownsampleFactor, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropEarlyStoppingEnabled, value.EarlyStoppingEnabled, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropEta, value.Eta, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropEtaGrowthRatePerTree, value.EtaGrowthRatePerTree, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropFeatureBagFraction, value.FeatureBagFraction, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropFeatureProcessors, value.FeatureProcessors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>(o, v, null));
		writer.WriteProperty(options, PropGamma, value.Gamma, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropLambda, value.Lambda, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropLossFunction, value.LossFunction, null, null);
		writer.WriteProperty(options, PropLossFunctionParameter, value.LossFunctionParameter, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropMaxOptimizationRoundsPerHyperparameter, value.MaxOptimizationRoundsPerHyperparameter, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxTrees, value.MaxTrees, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNumTopFeatureImportanceValues, value.NumTopFeatureImportanceValues, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropPredictionFieldName, value.PredictionFieldName, null, null);
		writer.WriteProperty(options, PropRandomizeSeed, value.RandomizeSeed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropSoftTreeDepthLimit, value.SoftTreeDepthLimit, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSoftTreeDepthTolerance, value.SoftTreeDepthTolerance, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropTrainingPercent, value.TrainingPercent, null, null);
		writer.WriteEndObject();
	}
}