// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DataframeAnalysisOutlierDetectionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection>
{
	private static readonly System.Text.Json.JsonEncodedText PropComputeFeatureInfluence = System.Text.Json.JsonEncodedText.Encode("compute_feature_influence");
	private static readonly System.Text.Json.JsonEncodedText PropFeatureInfluenceThreshold = System.Text.Json.JsonEncodedText.Encode("feature_influence_threshold");
	private static readonly System.Text.Json.JsonEncodedText PropMethod = System.Text.Json.JsonEncodedText.Encode("method");
	private static readonly System.Text.Json.JsonEncodedText PropNNeighbors = System.Text.Json.JsonEncodedText.Encode("n_neighbors");
	private static readonly System.Text.Json.JsonEncodedText PropOutlierFraction = System.Text.Json.JsonEncodedText.Encode("outlier_fraction");
	private static readonly System.Text.Json.JsonEncodedText PropStandardizationEnabled = System.Text.Json.JsonEncodedText.Encode("standardization_enabled");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool?> propComputeFeatureInfluence = default;
		LocalJsonValue<double?> propFeatureInfluenceThreshold = default;
		LocalJsonValue<string?> propMethod = default;
		LocalJsonValue<int?> propNNeighbors = default;
		LocalJsonValue<double?> propOutlierFraction = default;
		LocalJsonValue<bool?> propStandardizationEnabled = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propComputeFeatureInfluence.TryReadProperty(ref reader, options, PropComputeFeatureInfluence, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propFeatureInfluenceThreshold.TryReadProperty(ref reader, options, PropFeatureInfluenceThreshold, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propMethod.TryReadProperty(ref reader, options, PropMethod, null))
			{
				continue;
			}

			if (propNNeighbors.TryReadProperty(ref reader, options, PropNNeighbors, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propOutlierFraction.TryReadProperty(ref reader, options, PropOutlierFraction, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propStandardizationEnabled.TryReadProperty(ref reader, options, PropStandardizationEnabled, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ComputeFeatureInfluence = propComputeFeatureInfluence.Value,
			FeatureInfluenceThreshold = propFeatureInfluenceThreshold.Value,
			Method = propMethod.Value,
			NNeighbors = propNNeighbors.Value,
			OutlierFraction = propOutlierFraction.Value,
			StandardizationEnabled = propStandardizationEnabled.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropComputeFeatureInfluence, value.ComputeFeatureInfluence, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropFeatureInfluenceThreshold, value.FeatureInfluenceThreshold, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropMethod, value.Method, null, null);
		writer.WriteProperty(options, PropNNeighbors, value.NNeighbors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropOutlierFraction, value.OutlierFraction, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropStandardizationEnabled, value.StandardizationEnabled, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteEndObject();
	}
}