// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DataframeAnalysisFeatureProcessorConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>
{
	private static readonly System.Text.Json.JsonEncodedText VariantFrequencyEncoding = System.Text.Json.JsonEncodedText.Encode("frequency_encoding");
	private static readonly System.Text.Json.JsonEncodedText VariantMultiEncoding = System.Text.Json.JsonEncodedText.Encode("multi_encoding");
	private static readonly System.Text.Json.JsonEncodedText VariantNGramEncoding = System.Text.Json.JsonEncodedText.Encode("n_gram_encoding");
	private static readonly System.Text.Json.JsonEncodedText VariantOneHotEncoding = System.Text.Json.JsonEncodedText.Encode("one_hot_encoding");
	private static readonly System.Text.Json.JsonEncodedText VariantTargetMeanEncoding = System.Text.Json.JsonEncodedText.Encode("target_mean_encoding");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantFrequencyEncoding))
			{
				variantType = VariantFrequencyEncoding.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorFrequencyEncoding>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMultiEncoding))
			{
				variantType = VariantMultiEncoding.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorMultiEncoding>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNGramEncoding))
			{
				variantType = VariantNGramEncoding.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorNGramEncoding>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantOneHotEncoding))
			{
				variantType = VariantOneHotEncoding.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorOneHotEncoding>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTargetMeanEncoding))
			{
				variantType = VariantTargetMeanEncoding.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorTargetMeanEncoding>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "frequency_encoding":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorFrequencyEncoding)value.Variant, null, null);
				break;
			case "multi_encoding":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorMultiEncoding)value.Variant, null, null);
				break;
			case "n_gram_encoding":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorNGramEncoding)value.Variant, null, null);
				break;
			case "one_hot_encoding":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorOneHotEncoding)value.Variant, null, null);
				break;
			case "target_mean_encoding":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorTargetMeanEncoding)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor)}'.");
		}

		writer.WriteEndObject();
	}
}