// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeAnalysisClassificationConverter))]
public sealed partial class DataframeAnalysisClassification
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisClassification(string dependentVariable)
	{
		DependentVariable = dependentVariable;
	}
#if NET7_0_OR_GREATER
	public DataframeAnalysisClassification()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataframeAnalysisClassification()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This parameter affects loss calculations by acting as a multiplier of the tree depth. Higher alpha values result in shallower trees and faster training times. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to zero.
	/// </para>
	/// </summary>
	public double? Alpha { get; set; }
	public string? ClassAssignmentObjective { get; set; }

	/// <summary>
	/// <para>
	/// Defines which field of the document is to be predicted. It must match one of the fields in the index being used to train. If this field is missing from a document, then that document will not be used for training, but a prediction with the trained model will be generated for it. It is also known as continuous target variable.
	/// For classification analysis, the data type of the field must be numeric (<c>integer</c>, <c>short</c>, <c>long</c>, <c>byte</c>), categorical (<c>ip</c> or <c>keyword</c>), or <c>boolean</c>. There must be no more than 30 different values in this field.
	/// For regression analysis, the data type of the field must be numeric.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DependentVariable { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Controls the fraction of data that is used to compute the derivatives of the loss function for tree training. A small value results in the use of a small fraction of the data. If this value is set to be less than 1, accuracy typically improves. However, too small a value may result in poor convergence for the ensemble and so require more trees. By default, this value is calculated during hyperparameter optimization. It must be greater than zero and less than or equal to 1.
	/// </para>
	/// </summary>
	public double? DownsampleFactor { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies whether the training process should finish if it is not finding any better performing models. If disabled, the training process can take significantly longer and the chance of finding a better performing model is unremarkable.
	/// </para>
	/// </summary>
	public bool? EarlyStoppingEnabled { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. The shrinkage applied to the weights. Smaller values result in larger forests which have a better generalization error. However, larger forests cause slower training. By default, this value is calculated during hyperparameter optimization. It must be a value between 0.001 and 1.
	/// </para>
	/// </summary>
	public double? Eta { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies the rate at which <c>eta</c> increases for each new tree that is added to the forest. For example, a rate of 1.05 increases <c>eta</c> by 5% for each extra tree. By default, this value is calculated during hyperparameter optimization. It must be between 0.5 and 2.
	/// </para>
	/// </summary>
	public double? EtaGrowthRatePerTree { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Defines the fraction of features that will be used when selecting a random bag for each candidate split. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public double? FeatureBagFraction { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>? FeatureProcessors { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies a linear penalty associated with the size of individual trees in the forest. A high gamma value causes training to prefer small trees. A small gamma value results in larger individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.
	/// </para>
	/// </summary>
	public double? Gamma { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies an L2 regularization term which applies to leaf weights of the individual trees in the forest. A high lambda value causes training to favor small leaf weights. This behavior makes the prediction function smoother at the expense of potentially not being able to capture relevant relationships between the features and the dependent variable. A small lambda value results in large individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.
	/// </para>
	/// </summary>
	public double? Lambda { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. A multiplier responsible for determining the maximum number of hyperparameter optimization steps in the Bayesian optimization procedure. The maximum number of steps is determined based on the number of undefined hyperparameters times the maximum optimization rounds per hyperparameter. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public int? MaxOptimizationRoundsPerHyperparameter { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Defines the maximum number of decision trees in the forest. The maximum value is 2000. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public int? MaxTrees { get; set; }

	/// <summary>
	/// <para>
	/// Defines the number of categories for which the predicted probabilities are reported. It must be non-negative or -1. If it is -1 or greater than the total number of categories, probabilities are reported for all categories; if you have a large number of categories, there could be a significant effect on the size of your destination index. NOTE: To use the AUC ROC evaluation method, <c>num_top_classes</c> must be set to -1 or a value greater than or equal to the total number of categories.
	/// </para>
	/// </summary>
	public int? NumTopClasses { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies the maximum number of feature importance values per document to return. By default, no feature importance calculation occurs.
	/// </para>
	/// </summary>
	public int? NumTopFeatureImportanceValues { get; set; }

	/// <summary>
	/// <para>
	/// Defines the name of the prediction field in the results. Defaults to <c>&lt;dependent_variable>_prediction</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? PredictionFieldName { get; set; }

	/// <summary>
	/// <para>
	/// Defines the seed for the random generator that is used to pick training data. By default, it is randomly generated. Set it to a specific value to use the same training data each time you start a job (assuming other related parameters such as <c>source</c> and <c>analyzed_fields</c> are the same).
	/// </para>
	/// </summary>
	public double? RandomizeSeed { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This soft limit combines with the <c>soft_tree_depth_tolerance</c> to penalize trees that exceed the specified depth; the regularized loss increases quickly beyond this depth. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.
	/// </para>
	/// </summary>
	public int? SoftTreeDepthLimit { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. This option controls how quickly the regularized loss increases when the tree depth exceeds <c>soft_tree_depth_limit</c>. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.01.
	/// </para>
	/// </summary>
	public double? SoftTreeDepthTolerance { get; set; }

	/// <summary>
	/// <para>
	/// Defines what percentage of the eligible documents that will be used for training. Documents that are ignored by the analysis (for example those that contain arrays with more than one value) won’t be included in the calculation for used percentage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Percentage? TrainingPercent { get; set; }
}

public readonly partial struct DataframeAnalysisClassificationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisClassificationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisClassificationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This parameter affects loss calculations by acting as a multiplier of the tree depth. Higher alpha values result in shallower trees and faster training times. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to zero.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> Alpha(double? value)
	{
		Instance.Alpha = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> ClassAssignmentObjective(string? value)
	{
		Instance.ClassAssignmentObjective = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines which field of the document is to be predicted. It must match one of the fields in the index being used to train. If this field is missing from a document, then that document will not be used for training, but a prediction with the trained model will be generated for it. It is also known as continuous target variable.
	/// For classification analysis, the data type of the field must be numeric (<c>integer</c>, <c>short</c>, <c>long</c>, <c>byte</c>), categorical (<c>ip</c> or <c>keyword</c>), or <c>boolean</c>. There must be no more than 30 different values in this field.
	/// For regression analysis, the data type of the field must be numeric.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> DependentVariable(string value)
	{
		Instance.DependentVariable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Controls the fraction of data that is used to compute the derivatives of the loss function for tree training. A small value results in the use of a small fraction of the data. If this value is set to be less than 1, accuracy typically improves. However, too small a value may result in poor convergence for the ensemble and so require more trees. By default, this value is calculated during hyperparameter optimization. It must be greater than zero and less than or equal to 1.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> DownsampleFactor(double? value)
	{
		Instance.DownsampleFactor = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies whether the training process should finish if it is not finding any better performing models. If disabled, the training process can take significantly longer and the chance of finding a better performing model is unremarkable.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> EarlyStoppingEnabled(bool? value = true)
	{
		Instance.EarlyStoppingEnabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The shrinkage applied to the weights. Smaller values result in larger forests which have a better generalization error. However, larger forests cause slower training. By default, this value is calculated during hyperparameter optimization. It must be a value between 0.001 and 1.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> Eta(double? value)
	{
		Instance.Eta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies the rate at which <c>eta</c> increases for each new tree that is added to the forest. For example, a rate of 1.05 increases <c>eta</c> by 5% for each extra tree. By default, this value is calculated during hyperparameter optimization. It must be between 0.5 and 2.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> EtaGrowthRatePerTree(double? value)
	{
		Instance.EtaGrowthRatePerTree = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Defines the fraction of features that will be used when selecting a random bag for each candidate split. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> FeatureBagFraction(double? value)
	{
		Instance.FeatureBagFraction = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> FeatureProcessors(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>? value)
	{
		Instance.FeatureProcessors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> FeatureProcessors(params Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor[] values)
	{
		Instance.FeatureProcessors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> FeatureProcessors(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.FeatureProcessors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies a linear penalty associated with the size of individual trees in the forest. A high gamma value causes training to prefer small trees. A small gamma value results in larger individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> Gamma(double? value)
	{
		Instance.Gamma = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies an L2 regularization term which applies to leaf weights of the individual trees in the forest. A high lambda value causes training to favor small leaf weights. This behavior makes the prediction function smoother at the expense of potentially not being able to capture relevant relationships between the features and the dependent variable. A small lambda value results in large individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> Lambda(double? value)
	{
		Instance.Lambda = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A multiplier responsible for determining the maximum number of hyperparameter optimization steps in the Bayesian optimization procedure. The maximum number of steps is determined based on the number of undefined hyperparameters times the maximum optimization rounds per hyperparameter. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> MaxOptimizationRoundsPerHyperparameter(int? value)
	{
		Instance.MaxOptimizationRoundsPerHyperparameter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Defines the maximum number of decision trees in the forest. The maximum value is 2000. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> MaxTrees(int? value)
	{
		Instance.MaxTrees = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the number of categories for which the predicted probabilities are reported. It must be non-negative or -1. If it is -1 or greater than the total number of categories, probabilities are reported for all categories; if you have a large number of categories, there could be a significant effect on the size of your destination index. NOTE: To use the AUC ROC evaluation method, <c>num_top_classes</c> must be set to -1 or a value greater than or equal to the total number of categories.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> NumTopClasses(int? value)
	{
		Instance.NumTopClasses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies the maximum number of feature importance values per document to return. By default, no feature importance calculation occurs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the name of the prediction field in the results. Defaults to <c>&lt;dependent_variable>_prediction</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> PredictionFieldName(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.PredictionFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the name of the prediction field in the results. Defaults to <c>&lt;dependent_variable>_prediction</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> PredictionFieldName(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.PredictionFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the seed for the random generator that is used to pick training data. By default, it is randomly generated. Set it to a specific value to use the same training data each time you start a job (assuming other related parameters such as <c>source</c> and <c>analyzed_fields</c> are the same).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> RandomizeSeed(double? value)
	{
		Instance.RandomizeSeed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This soft limit combines with the <c>soft_tree_depth_tolerance</c> to penalize trees that exceed the specified depth; the regularized loss increases quickly beyond this depth. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> SoftTreeDepthLimit(int? value)
	{
		Instance.SoftTreeDepthLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. This option controls how quickly the regularized loss increases when the tree depth exceeds <c>soft_tree_depth_limit</c>. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.01.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> SoftTreeDepthTolerance(double? value)
	{
		Instance.SoftTreeDepthTolerance = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines what percentage of the eligible documents that will be used for training. Documents that are ignored by the analysis (for example those that contain arrays with more than one value) won’t be included in the calculation for used percentage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> TrainingPercent(Elastic.Clients.Elasticsearch.Percentage? value)
	{
		Instance.TrainingPercent = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines what percentage of the eligible documents that will be used for training. Documents that are ignored by the analysis (for example those that contain arrays with more than one value) won’t be included in the calculation for used percentage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument> TrainingPercent(System.Func<Elastic.Clients.Elasticsearch.PercentageFactory, Elastic.Clients.Elasticsearch.Percentage> action)
	{
		Instance.TrainingPercent = Elastic.Clients.Elasticsearch.PercentageFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DataframeAnalysisClassificationDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisClassificationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisClassificationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This parameter affects loss calculations by acting as a multiplier of the tree depth. Higher alpha values result in shallower trees and faster training times. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to zero.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor Alpha(double? value)
	{
		Instance.Alpha = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor ClassAssignmentObjective(string? value)
	{
		Instance.ClassAssignmentObjective = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines which field of the document is to be predicted. It must match one of the fields in the index being used to train. If this field is missing from a document, then that document will not be used for training, but a prediction with the trained model will be generated for it. It is also known as continuous target variable.
	/// For classification analysis, the data type of the field must be numeric (<c>integer</c>, <c>short</c>, <c>long</c>, <c>byte</c>), categorical (<c>ip</c> or <c>keyword</c>), or <c>boolean</c>. There must be no more than 30 different values in this field.
	/// For regression analysis, the data type of the field must be numeric.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor DependentVariable(string value)
	{
		Instance.DependentVariable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Controls the fraction of data that is used to compute the derivatives of the loss function for tree training. A small value results in the use of a small fraction of the data. If this value is set to be less than 1, accuracy typically improves. However, too small a value may result in poor convergence for the ensemble and so require more trees. By default, this value is calculated during hyperparameter optimization. It must be greater than zero and less than or equal to 1.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor DownsampleFactor(double? value)
	{
		Instance.DownsampleFactor = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies whether the training process should finish if it is not finding any better performing models. If disabled, the training process can take significantly longer and the chance of finding a better performing model is unremarkable.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor EarlyStoppingEnabled(bool? value = true)
	{
		Instance.EarlyStoppingEnabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The shrinkage applied to the weights. Smaller values result in larger forests which have a better generalization error. However, larger forests cause slower training. By default, this value is calculated during hyperparameter optimization. It must be a value between 0.001 and 1.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor Eta(double? value)
	{
		Instance.Eta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies the rate at which <c>eta</c> increases for each new tree that is added to the forest. For example, a rate of 1.05 increases <c>eta</c> by 5% for each extra tree. By default, this value is calculated during hyperparameter optimization. It must be between 0.5 and 2.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor EtaGrowthRatePerTree(double? value)
	{
		Instance.EtaGrowthRatePerTree = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Defines the fraction of features that will be used when selecting a random bag for each candidate split. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor FeatureBagFraction(double? value)
	{
		Instance.FeatureBagFraction = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor FeatureProcessors(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>? value)
	{
		Instance.FeatureProcessors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor FeatureProcessors(params Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor[] values)
	{
		Instance.FeatureProcessors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor FeatureProcessors(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorDescriptor.Build(action));
		}

		Instance.FeatureProcessors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple <c>feature_processors</c> entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor FeatureProcessors<T>(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisFeatureProcessorDescriptor<T>.Build(action));
		}

		Instance.FeatureProcessors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies a linear penalty associated with the size of individual trees in the forest. A high gamma value causes training to prefer small trees. A small gamma value results in larger individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor Gamma(double? value)
	{
		Instance.Gamma = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies an L2 regularization term which applies to leaf weights of the individual trees in the forest. A high lambda value causes training to favor small leaf weights. This behavior makes the prediction function smoother at the expense of potentially not being able to capture relevant relationships between the features and the dependent variable. A small lambda value results in large individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor Lambda(double? value)
	{
		Instance.Lambda = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. A multiplier responsible for determining the maximum number of hyperparameter optimization steps in the Bayesian optimization procedure. The maximum number of steps is determined based on the number of undefined hyperparameters times the maximum optimization rounds per hyperparameter. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor MaxOptimizationRoundsPerHyperparameter(int? value)
	{
		Instance.MaxOptimizationRoundsPerHyperparameter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Defines the maximum number of decision trees in the forest. The maximum value is 2000. By default, this value is calculated during hyperparameter optimization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor MaxTrees(int? value)
	{
		Instance.MaxTrees = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the number of categories for which the predicted probabilities are reported. It must be non-negative or -1. If it is -1 or greater than the total number of categories, probabilities are reported for all categories; if you have a large number of categories, there could be a significant effect on the size of your destination index. NOTE: To use the AUC ROC evaluation method, <c>num_top_classes</c> must be set to -1 or a value greater than or equal to the total number of categories.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor NumTopClasses(int? value)
	{
		Instance.NumTopClasses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies the maximum number of feature importance values per document to return. By default, no feature importance calculation occurs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the name of the prediction field in the results. Defaults to <c>&lt;dependent_variable>_prediction</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor PredictionFieldName(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.PredictionFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the name of the prediction field in the results. Defaults to <c>&lt;dependent_variable>_prediction</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor PredictionFieldName<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.PredictionFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the seed for the random generator that is used to pick training data. By default, it is randomly generated. Set it to a specific value to use the same training data each time you start a job (assuming other related parameters such as <c>source</c> and <c>analyzed_fields</c> are the same).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor RandomizeSeed(double? value)
	{
		Instance.RandomizeSeed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This soft limit combines with the <c>soft_tree_depth_tolerance</c> to penalize trees that exceed the specified depth; the regularized loss increases quickly beyond this depth. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor SoftTreeDepthLimit(int? value)
	{
		Instance.SoftTreeDepthLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. This option controls how quickly the regularized loss increases when the tree depth exceeds <c>soft_tree_depth_limit</c>. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.01.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor SoftTreeDepthTolerance(double? value)
	{
		Instance.SoftTreeDepthTolerance = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines what percentage of the eligible documents that will be used for training. Documents that are ignored by the analysis (for example those that contain arrays with more than one value) won’t be included in the calculation for used percentage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor TrainingPercent(Elastic.Clients.Elasticsearch.Percentage? value)
	{
		Instance.TrainingPercent = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines what percentage of the eligible documents that will be used for training. Documents that are ignored by the analysis (for example those that contain arrays with more than one value) won’t be included in the calculation for used percentage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor TrainingPercent(System.Func<Elastic.Clients.Elasticsearch.PercentageFactory, Elastic.Clients.Elasticsearch.Percentage> action)
	{
		Instance.TrainingPercent = Elastic.Clients.Elasticsearch.PercentageFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}