// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataframeAnalysisConverter))]
public sealed partial class DataframeAnalysis
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public DataframeAnalysis()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataframeAnalysis()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataframeAnalysis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform classification.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification? Classification { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification>("classification"); set => SetVariant("classification", value); }

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection? OutlierDetection { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection>("outlier_detection"); set => SetVariant("outlier_detection", value); }

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform regression. NOTE: Advanced parameters are for fine-tuning regression analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression? Regression { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression>("regression"); set => SetVariant("regression", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification value) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis { Classification = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection value) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis { OutlierDetection = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression value) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis { Regression = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct DataframeAnalysisDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform classification.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> Classification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform classification.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> Classification(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument>> action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> OutlierDetection(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection? value)
	{
		Instance.OutlierDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> OutlierDetection()
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetectionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> OutlierDetection(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetectionDescriptor>? action)
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetectionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform regression. NOTE: Advanced parameters are for fine-tuning regression analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> Regression(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform regression. NOTE: Advanced parameters are for fine-tuning regression analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument> Regression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegressionDescriptor<TDocument>> action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegressionDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DataframeAnalysisDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataframeAnalysisDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform classification.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor Classification(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassification? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform classification.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor Classification(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor> action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform classification.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor Classification<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<T>> action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisClassificationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor OutlierDetection(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetection? value)
	{
		Instance.OutlierDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor OutlierDetection()
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetectionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform outlier detection. NOTE: Advanced parameters are for fine-tuning classification analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor OutlierDetection(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetectionDescriptor>? action)
	{
		Instance.OutlierDetection = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisOutlierDetectionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform regression. NOTE: Advanced parameters are for fine-tuning regression analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor Regression(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegression? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform regression. NOTE: Advanced parameters are for fine-tuning regression analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor Regression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegressionDescriptor> action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegressionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration information necessary to perform regression. NOTE: Advanced parameters are for fine-tuning regression analysis. They are set automatically by hyperparameter optimization to give the minimum validation error. It is highly recommended to use the default values unless you fully understand the function of these parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor Regression<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegressionDescriptor<T>> action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisRegressionDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}