// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DatafeedTimingStatsConverter))]
public sealed partial class DatafeedTimingStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DatafeedTimingStats(long bucketCount, System.TimeSpan exponentialAverageSearchTimePerHourMs, string jobId, long searchCount, System.TimeSpan totalSearchTimeMs)
	{
		BucketCount = bucketCount;
		ExponentialAverageSearchTimePerHourMs = exponentialAverageSearchTimePerHourMs;
		JobId = jobId;
		SearchCount = searchCount;
		TotalSearchTimeMs = totalSearchTimeMs;
	}
#if NET7_0_OR_GREATER
	public DatafeedTimingStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DatafeedTimingStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DatafeedTimingStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The average search time per bucket, in milliseconds.
	/// </para>
	/// </summary>
	public System.TimeSpan? AverageSearchTimePerBucketMs { get; set; }

	/// <summary>
	/// <para>
	/// The number of buckets processed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long BucketCount { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.ExponentialAverageCalculationContext? ExponentialAverageCalculationContext { get; set; }

	/// <summary>
	/// <para>
	/// The exponential average search time per hour, in milliseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ExponentialAverageSearchTimePerHourMs { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// The number of searches run by the datafeed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SearchCount { get; set; }

	/// <summary>
	/// <para>
	/// The total time the datafeed spent searching, in milliseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalSearchTimeMs { get; set; }
}