// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DatafeedTimingStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedTimingStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAverageSearchTimePerBucketMs = System.Text.Json.JsonEncodedText.Encode("average_search_time_per_bucket_ms");
	private static readonly System.Text.Json.JsonEncodedText PropBucketCount = System.Text.Json.JsonEncodedText.Encode("bucket_count");
	private static readonly System.Text.Json.JsonEncodedText PropExponentialAverageCalculationContext = System.Text.Json.JsonEncodedText.Encode("exponential_average_calculation_context");
	private static readonly System.Text.Json.JsonEncodedText PropExponentialAverageSearchTimePerHourMs = System.Text.Json.JsonEncodedText.Encode("exponential_average_search_time_per_hour_ms");
	private static readonly System.Text.Json.JsonEncodedText PropJobId = System.Text.Json.JsonEncodedText.Encode("job_id");
	private static readonly System.Text.Json.JsonEncodedText PropSearchCount = System.Text.Json.JsonEncodedText.Encode("search_count");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSearchTimeMs = System.Text.Json.JsonEncodedText.Encode("total_search_time_ms");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DatafeedTimingStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.TimeSpan?> propAverageSearchTimePerBucketMs = default;
		LocalJsonValue<long> propBucketCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.ExponentialAverageCalculationContext?> propExponentialAverageCalculationContext = default;
		LocalJsonValue<System.TimeSpan> propExponentialAverageSearchTimePerHourMs = default;
		LocalJsonValue<string> propJobId = default;
		LocalJsonValue<long> propSearchCount = default;
		LocalJsonValue<System.TimeSpan> propTotalSearchTimeMs = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAverageSearchTimePerBucketMs.TryReadProperty(ref reader, options, PropAverageSearchTimePerBucketMs, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propBucketCount.TryReadProperty(ref reader, options, PropBucketCount, null))
			{
				continue;
			}

			if (propExponentialAverageCalculationContext.TryReadProperty(ref reader, options, PropExponentialAverageCalculationContext, null))
			{
				continue;
			}

			if (propExponentialAverageSearchTimePerHourMs.TryReadProperty(ref reader, options, PropExponentialAverageSearchTimePerHourMs, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propJobId.TryReadProperty(ref reader, options, PropJobId, null))
			{
				continue;
			}

			if (propSearchCount.TryReadProperty(ref reader, options, PropSearchCount, null))
			{
				continue;
			}

			if (propTotalSearchTimeMs.TryReadProperty(ref reader, options, PropTotalSearchTimeMs, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DatafeedTimingStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AverageSearchTimePerBucketMs = propAverageSearchTimePerBucketMs.Value,
			BucketCount = propBucketCount.Value,
			ExponentialAverageCalculationContext = propExponentialAverageCalculationContext.Value,
			ExponentialAverageSearchTimePerHourMs = propExponentialAverageSearchTimePerHourMs.Value,
			JobId = propJobId.Value,
			SearchCount = propSearchCount.Value,
			TotalSearchTimeMs = propTotalSearchTimeMs.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DatafeedTimingStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAverageSearchTimePerBucketMs, value.AverageSearchTimePerBucketMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropBucketCount, value.BucketCount, null, null);
		writer.WriteProperty(options, PropExponentialAverageCalculationContext, value.ExponentialAverageCalculationContext, null, null);
		writer.WriteProperty(options, PropExponentialAverageSearchTimePerHourMs, value.ExponentialAverageSearchTimePerHourMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropJobId, value.JobId, null, null);
		writer.WriteProperty(options, PropSearchCount, value.SearchCount, null, null);
		writer.WriteProperty(options, PropTotalSearchTimeMs, value.TotalSearchTimeMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteEndObject();
	}
}