// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DatafeedStatsConverter))]
public sealed partial class DatafeedStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DatafeedStats(string datafeedId, Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState state)
	{
		DatafeedId = datafeedId;
		State = state;
	}
#if NET7_0_OR_GREATER
	public DatafeedStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DatafeedStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DatafeedStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For started datafeeds only, contains messages relating to the selection of a node.
	/// </para>
	/// </summary>
	public string? AssignmentExplanation { get; set; }

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed.
	/// This identifier can contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores.
	/// It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DatafeedId { get; set; }

	/// <summary>
	/// <para>
	/// For started datafeeds only, this information pertains to the node upon which the datafeed is started.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeCompact? Node { get; set; }

	/// <summary>
	/// <para>
	/// An object containing the running state for this datafeed.
	/// It is only provided if the datafeed is started.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DatafeedRunningState? RunningState { get; set; }

	/// <summary>
	/// <para>
	/// The status of the datafeed, which can be one of the following values: <c>starting</c>, <c>started</c>, <c>stopping</c>, <c>stopped</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState State { get; set; }

	/// <summary>
	/// <para>
	/// An object that provides statistical information about timing aspect of this datafeed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DatafeedTimingStats? TimingStats { get; set; }
}