// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DatafeedStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAssignmentExplanation = System.Text.Json.JsonEncodedText.Encode("assignment_explanation");
	private static readonly System.Text.Json.JsonEncodedText PropDatafeedId = System.Text.Json.JsonEncodedText.Encode("datafeed_id");
	private static readonly System.Text.Json.JsonEncodedText PropNode = System.Text.Json.JsonEncodedText.Encode("node");
	private static readonly System.Text.Json.JsonEncodedText PropRunningState = System.Text.Json.JsonEncodedText.Encode("running_state");
	private static readonly System.Text.Json.JsonEncodedText PropState = System.Text.Json.JsonEncodedText.Encode("state");
	private static readonly System.Text.Json.JsonEncodedText PropTimingStats = System.Text.Json.JsonEncodedText.Encode("timing_stats");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DatafeedStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAssignmentExplanation = default;
		LocalJsonValue<string> propDatafeedId = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeCompact?> propNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedRunningState?> propRunningState = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState> propState = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedTimingStats?> propTimingStats = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAssignmentExplanation.TryReadProperty(ref reader, options, PropAssignmentExplanation, null))
			{
				continue;
			}

			if (propDatafeedId.TryReadProperty(ref reader, options, PropDatafeedId, null))
			{
				continue;
			}

			if (propNode.TryReadProperty(ref reader, options, PropNode, null))
			{
				continue;
			}

			if (propRunningState.TryReadProperty(ref reader, options, PropRunningState, null))
			{
				continue;
			}

			if (propState.TryReadProperty(ref reader, options, PropState, null))
			{
				continue;
			}

			if (propTimingStats.TryReadProperty(ref reader, options, PropTimingStats, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DatafeedStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AssignmentExplanation = propAssignmentExplanation.Value,
			DatafeedId = propDatafeedId.Value,
			Node = propNode.Value,
			RunningState = propRunningState.Value,
			State = propState.Value,
			TimingStats = propTimingStats.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DatafeedStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAssignmentExplanation, value.AssignmentExplanation, null, null);
		writer.WriteProperty(options, PropDatafeedId, value.DatafeedId, null, null);
		writer.WriteProperty(options, PropNode, value.Node, null, null);
		writer.WriteProperty(options, PropRunningState, value.RunningState, null, null);
		writer.WriteProperty(options, PropState, value.State, null, null);
		writer.WriteProperty(options, PropTimingStats, value.TimingStats, null, null);
		writer.WriteEndObject();
	}
}