// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DatafeedStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberStarted = System.Text.Json.JsonEncodedText.Encode("started");
	private static readonly System.Text.Json.JsonEncodedText MemberStarting = System.Text.Json.JsonEncodedText.Encode("starting");
	private static readonly System.Text.Json.JsonEncodedText MemberStopped = System.Text.Json.JsonEncodedText.Encode("stopped");
	private static readonly System.Text.Json.JsonEncodedText MemberStopping = System.Text.Json.JsonEncodedText.Encode("stopping");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberStarted))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Started;
		}

		if (reader.ValueTextEquals(MemberStarting))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Starting;
		}

		if (reader.ValueTextEquals(MemberStopped))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Stopped;
		}

		if (reader.ValueTextEquals(MemberStopping))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Stopping;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberStarted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Started;
		}

		if (string.Equals(value, MemberStarting.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Starting;
		}

		if (string.Equals(value, MemberStopped.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Stopped;
		}

		if (string.Equals(value, MemberStopping.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Stopping;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Started:
				writer.WriteStringValue(MemberStarted);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Starting:
				writer.WriteStringValue(MemberStarting);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Stopped:
				writer.WriteStringValue(MemberStopped);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState.Stopping:
				writer.WriteStringValue(MemberStopping);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DatafeedState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}