// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DatafeedRunningStateConverter))]
public sealed partial class DatafeedRunningState
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DatafeedRunningState(bool realTimeConfigured, bool realTimeRunning)
	{
		RealTimeConfigured = realTimeConfigured;
		RealTimeRunning = realTimeRunning;
	}
#if NET7_0_OR_GREATER
	public DatafeedRunningState()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DatafeedRunningState()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DatafeedRunningState(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates if the datafeed is "real-time"; meaning that the datafeed has no configured <c>end</c> time.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool RealTimeConfigured { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the datafeed has finished running on the available past data.
	/// For datafeeds without a configured <c>end</c> time, this means that the datafeed is now running on "real-time" data.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool RealTimeRunning { get; set; }

	/// <summary>
	/// <para>
	/// Provides the latest time interval the datafeed has searched.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.RunningStateSearchInterval? SearchInterval { get; set; }
}