// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class DatafeedRunningStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.DatafeedRunningState>
{
	private static readonly System.Text.Json.JsonEncodedText PropRealTimeConfigured = System.Text.Json.JsonEncodedText.Encode("real_time_configured");
	private static readonly System.Text.Json.JsonEncodedText PropRealTimeRunning = System.Text.Json.JsonEncodedText.Encode("real_time_running");
	private static readonly System.Text.Json.JsonEncodedText PropSearchInterval = System.Text.Json.JsonEncodedText.Encode("search_interval");

	public override Elastic.Clients.Elasticsearch.MachineLearning.DatafeedRunningState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool> propRealTimeConfigured = default;
		LocalJsonValue<bool> propRealTimeRunning = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.RunningStateSearchInterval?> propSearchInterval = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propRealTimeConfigured.TryReadProperty(ref reader, options, PropRealTimeConfigured, null))
			{
				continue;
			}

			if (propRealTimeRunning.TryReadProperty(ref reader, options, PropRealTimeRunning, null))
			{
				continue;
			}

			if (propSearchInterval.TryReadProperty(ref reader, options, PropSearchInterval, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.DatafeedRunningState(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			RealTimeConfigured = propRealTimeConfigured.Value,
			RealTimeRunning = propRealTimeRunning.Value,
			SearchInterval = propSearchInterval.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.DatafeedRunningState value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropRealTimeConfigured, value.RealTimeConfigured, null, null);
		writer.WriteProperty(options, PropRealTimeRunning, value.RealTimeRunning, null, null);
		writer.WriteProperty(options, PropSearchInterval, value.SearchInterval, null, null);
		writer.WriteEndObject();
	}
}