// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataDescriptionConverter))]
public sealed partial class DataDescription
{
#if NET7_0_OR_GREATER
	public DataDescription()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataDescription()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? FieldDelimiter { get; set; }

	/// <summary>
	/// <para>
	/// Only JSON format is supported at this time.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// The name of the field that contains the timestamp.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TimeField { get; set; }

	/// <summary>
	/// <para>
	/// The time format, which can be <c>epoch</c>, <c>epoch_ms</c>, or a custom pattern. The value <c>epoch</c> refers to UNIX or Epoch time (the number of seconds since 1 Jan 1970). The value <c>epoch_ms</c> indicates that time is measured in milliseconds since the epoch. The <c>epoch</c> and <c>epoch_ms</c> time formats accept either integer or real values. Custom patterns must conform to the Java DateTimeFormatter class. When you use date-time formatting patterns, it is recommended that you provide the full date, time and time zone. For example: <c>yyyy-MM-dd'T'HH:mm:ssX</c>. If the pattern that you specify is not sufficient to produce a complete timestamp, job creation fails.
	/// </para>
	/// </summary>
	public string? TimeFormat { get; set; }
}

public readonly partial struct DataDescriptionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataDescription Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataDescriptionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataDescription instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataDescriptionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.DataDescription instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument> FieldDelimiter(string? value)
	{
		Instance.FieldDelimiter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only JSON format is supported at this time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the timestamp.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument> TimeField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TimeField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the timestamp.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument> TimeField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TimeField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The time format, which can be <c>epoch</c>, <c>epoch_ms</c>, or a custom pattern. The value <c>epoch</c> refers to UNIX or Epoch time (the number of seconds since 1 Jan 1970). The value <c>epoch_ms</c> indicates that time is measured in milliseconds since the epoch. The <c>epoch</c> and <c>epoch_ms</c> time formats accept either integer or real values. Custom patterns must conform to the Java DateTimeFormatter class. When you use date-time formatting patterns, it is recommended that you provide the full date, time and time zone. For example: <c>yyyy-MM-dd'T'HH:mm:ssX</c>. If the pattern that you specify is not sufficient to produce a complete timestamp, job creation fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument> TimeFormat(string? value)
	{
		Instance.TimeFormat = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataDescription Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DataDescriptionDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DataDescription Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataDescriptionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataDescription instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataDescriptionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DataDescription instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor FieldDelimiter(string? value)
	{
		Instance.FieldDelimiter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only JSON format is supported at this time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the timestamp.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor TimeField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TimeField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the timestamp.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor TimeField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TimeField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The time format, which can be <c>epoch</c>, <c>epoch_ms</c>, or a custom pattern. The value <c>epoch</c> refers to UNIX or Epoch time (the number of seconds since 1 Jan 1970). The value <c>epoch_ms</c> indicates that time is measured in milliseconds since the epoch. The <c>epoch</c> and <c>epoch_ms</c> time formats accept either integer or real values. Custom patterns must conform to the Java DateTimeFormatter class. When you use date-time formatting patterns, it is recommended that you provide the full date, time and time zone. For example: <c>yyyy-MM-dd'T'HH:mm:ssX</c>. If the pattern that you specify is not sufficient to produce a complete timestamp, job creation fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor TimeFormat(string? value)
	{
		Instance.TimeFormat = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DataDescription Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DataDescriptionDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DataDescription(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}