// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DataCountsConverter))]
public sealed partial class DataCounts
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataCounts(long bucketCount, long emptyBucketCount, long inputBytes, long inputFieldCount, long inputRecordCount, long invalidDateCount, string jobId, long missingFieldCount, long outOfOrderTimestampCount, long processedFieldCount, long processedRecordCount, long sparseBucketCount)
	{
		BucketCount = bucketCount;
		EmptyBucketCount = emptyBucketCount;
		InputBytes = inputBytes;
		InputFieldCount = inputFieldCount;
		InputRecordCount = inputRecordCount;
		InvalidDateCount = invalidDateCount;
		JobId = jobId;
		MissingFieldCount = missingFieldCount;
		OutOfOrderTimestampCount = outOfOrderTimestampCount;
		ProcessedFieldCount = processedFieldCount;
		ProcessedRecordCount = processedRecordCount;
		SparseBucketCount = sparseBucketCount;
	}
#if NET7_0_OR_GREATER
	public DataCounts()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataCounts()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataCounts(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	long BucketCount { get; set; }
	public long? EarliestRecordTimestamp { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long EmptyBucketCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long InputBytes { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long InputFieldCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long InputRecordCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long InvalidDateCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }
	public long? LastDataTime { get; set; }
	public long? LatestBucketTimestamp { get; set; }
	public long? LatestEmptyBucketTimestamp { get; set; }
	public long? LatestRecordTimestamp { get; set; }
	public long? LatestSparseBucketTimestamp { get; set; }
	public long? LogTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MissingFieldCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long OutOfOrderTimestampCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ProcessedFieldCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ProcessedRecordCount { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SparseBucketCount { get; set; }
}