// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class ConfusionMatrixThresholdConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.ConfusionMatrixThreshold>
{
	private static readonly System.Text.Json.JsonEncodedText PropFalseNegative = System.Text.Json.JsonEncodedText.Encode("fn");
	private static readonly System.Text.Json.JsonEncodedText PropFalsePositive = System.Text.Json.JsonEncodedText.Encode("fp");
	private static readonly System.Text.Json.JsonEncodedText PropTrueNegative = System.Text.Json.JsonEncodedText.Encode("tn");
	private static readonly System.Text.Json.JsonEncodedText PropTruePositive = System.Text.Json.JsonEncodedText.Encode("tp");

	public override Elastic.Clients.Elasticsearch.MachineLearning.ConfusionMatrixThreshold Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propFalseNegative = default;
		LocalJsonValue<int> propFalsePositive = default;
		LocalJsonValue<int> propTrueNegative = default;
		LocalJsonValue<int> propTruePositive = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFalseNegative.TryReadProperty(ref reader, options, PropFalseNegative, null))
			{
				continue;
			}

			if (propFalsePositive.TryReadProperty(ref reader, options, PropFalsePositive, null))
			{
				continue;
			}

			if (propTrueNegative.TryReadProperty(ref reader, options, PropTrueNegative, null))
			{
				continue;
			}

			if (propTruePositive.TryReadProperty(ref reader, options, PropTruePositive, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.ConfusionMatrixThreshold(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FalseNegative = propFalseNegative.Value,
			FalsePositive = propFalsePositive.Value,
			TrueNegative = propTrueNegative.Value,
			TruePositive = propTruePositive.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ConfusionMatrixThreshold value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFalseNegative, value.FalseNegative, null, null);
		writer.WriteProperty(options, PropFalsePositive, value.FalsePositive, null, null);
		writer.WriteProperty(options, PropTrueNegative, value.TrueNegative, null, null);
		writer.WriteProperty(options, PropTruePositive, value.TruePositive, null, null);
		writer.WriteEndObject();
	}
}