// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class ConditionOperatorConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGt = System.Text.Json.JsonEncodedText.Encode("gt");
	private static readonly System.Text.Json.JsonEncodedText MemberGte = System.Text.Json.JsonEncodedText.Encode("gte");
	private static readonly System.Text.Json.JsonEncodedText MemberLt = System.Text.Json.JsonEncodedText.Encode("lt");
	private static readonly System.Text.Json.JsonEncodedText MemberLte = System.Text.Json.JsonEncodedText.Encode("lte");

	public override Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGt))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Gt;
		}

		if (reader.ValueTextEquals(MemberGte))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Gte;
		}

		if (reader.ValueTextEquals(MemberLt))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Lt;
		}

		if (reader.ValueTextEquals(MemberLte))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Lte;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Gt;
		}

		if (string.Equals(value, MemberGte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Gte;
		}

		if (string.Equals(value, MemberLt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Lt;
		}

		if (string.Equals(value, MemberLte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Lte;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Gt:
				writer.WriteStringValue(MemberGt);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Gte:
				writer.WriteStringValue(MemberGte);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Lt:
				writer.WriteStringValue(MemberLt);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator.Lte:
				writer.WriteStringValue(MemberLte);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}