// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ClassificationInferenceOptionsConverter))]
public sealed partial class ClassificationInferenceOptions
{
#if NET7_0_OR_GREATER
	public ClassificationInferenceOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ClassificationInferenceOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return. Defaults to 0.
	/// </para>
	/// </summary>
	public int? NumTopClasses { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public int? NumTopFeatureImportanceValues { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the type of the predicted field to write. Acceptable values are: string, number, boolean. When boolean is provided 1.0 is transformed to true and 0.0 to false.
	/// </para>
	/// </summary>
	public string? PredictionFieldType { get; set; }

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public string? ResultsField { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written. Defaults to top_classes.
	/// </para>
	/// </summary>
	public string? TopClassesResultsField { get; set; }
}

public readonly partial struct ClassificationInferenceOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClassificationInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClassificationInferenceOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions(Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return. Defaults to 0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor NumTopClasses(int? value)
	{
		Instance.NumTopClasses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the type of the predicted field to write. Acceptable values are: string, number, boolean. When boolean is provided 1.0 is transformed to true and 0.0 to false.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor PredictionFieldType(string? value)
	{
		Instance.PredictionFieldType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor ResultsField(string? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written. Defaults to top_classes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor TopClassesResultsField(string? value)
	{
		Instance.TopClassesResultsField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}