// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class ChunkingModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAuto = System.Text.Json.JsonEncodedText.Encode("auto");
	private static readonly System.Text.Json.JsonEncodedText MemberManual = System.Text.Json.JsonEncodedText.Encode("manual");
	private static readonly System.Text.Json.JsonEncodedText MemberOff = System.Text.Json.JsonEncodedText.Encode("off");

	public override Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAuto))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Auto;
		}

		if (reader.ValueTextEquals(MemberManual))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Manual;
		}

		if (reader.ValueTextEquals(MemberOff))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Off;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAuto.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Auto;
		}

		if (string.Equals(value, MemberManual.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Manual;
		}

		if (string.Equals(value, MemberOff.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Off;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Auto:
				writer.WriteStringValue(MemberAuto);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Manual:
				writer.WriteStringValue(MemberManual);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode.Off:
				writer.WriteStringValue(MemberOff);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}