// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ChunkingConfigConverter))]
public sealed partial class ChunkingConfig
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChunkingConfig(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode mode)
	{
		Mode = mode;
	}
#if NET7_0_OR_GREATER
	public ChunkingConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ChunkingConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ChunkingConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the mode is <c>auto</c>, the chunk size is dynamically calculated;
	/// this is the recommended value when the datafeed does not use aggregations.
	/// If the mode is <c>manual</c>, chunking is applied according to the specified <c>time_span</c>;
	/// use this mode when the datafeed uses aggregations. If the mode is <c>off</c>, no chunking is applied.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode Mode { get; set; }

	/// <summary>
	/// <para>
	/// The time span that each search will be querying. This setting is applicable only when the <c>mode</c> is set to <c>manual</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? TimeSpan { get; set; }
}

public readonly partial struct ChunkingConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChunkingConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChunkingConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If the mode is <c>auto</c>, the chunk size is dynamically calculated;
	/// this is the recommended value when the datafeed does not use aggregations.
	/// If the mode is <c>manual</c>, chunking is applied according to the specified <c>time_span</c>;
	/// use this mode when the datafeed uses aggregations. If the mode is <c>off</c>, no chunking is applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor Mode(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingMode value)
	{
		Instance.Mode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The time span that each search will be querying. This setting is applicable only when the <c>mode</c> is set to <c>manual</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor TimeSpan(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.TimeSpan = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}