// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.CategoryConverter))]
public sealed partial class Category
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Category(long categoryId, System.Collections.Generic.IReadOnlyCollection<string> examples, string jobId, long maxMatchingLength, string mlcategory, string regex, string resultType, string terms)
	{
		CategoryId = categoryId;
		Examples = examples;
		JobId = jobId;
		MaxMatchingLength = maxMatchingLength;
		Mlcategory = mlcategory;
		Regex = regex;
		ResultType = resultType;
		Terms = terms;
	}
#if NET7_0_OR_GREATER
	public Category()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Category()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Category(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A unique identifier for the category. category_id is unique at the job level, even when per-partition categorization is enabled.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long CategoryId { get; set; }

	/// <summary>
	/// <para>
	/// A list of examples of actual values that matched the category.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> Examples { get; set; }

	/// <summary>
	/// <para>
	/// [experimental] A Grok pattern that could be used in Logstash or an ingest pipeline to extract fields from messages that match the category. This field is experimental and may be changed or removed in a future release. The Grok patterns that are found are not optimal, but are often a good starting point for manual tweaking.
	/// </para>
	/// </summary>
	public string? GrokPattern { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// The maximum length of the fields that matched the category. The value is increased by 10% to enable matching for similar fields that have not been analyzed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MaxMatchingLength { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Mlcategory { get; set; }

	/// <summary>
	/// <para>
	/// The number of messages that have been matched by this category. This is only guaranteed to have the latest accurate count after a job _flush or _close
	/// </para>
	/// </summary>
	public long? NumMatches { get; set; }
	public string? P { get; set; }

	/// <summary>
	/// <para>
	/// If per-partition categorization is enabled, this property identifies the field used to segment the categorization. It is not present when per-partition categorization is disabled.
	/// </para>
	/// </summary>
	public string? PartitionFieldName { get; set; }

	/// <summary>
	/// <para>
	/// If per-partition categorization is enabled, this property identifies the value of the partition_field_name for the category. It is not present when per-partition categorization is disabled.
	/// </para>
	/// </summary>
	public string? PartitionFieldValue { get; set; }

	/// <summary>
	/// <para>
	/// A list of category_id entries that this current category encompasses. Any new message that is processed by the categorizer will match against this category and not any of the categories in this list. This is only guaranteed to have the latest accurate list of categories after a job _flush or _close
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<string>? PreferredToCategories { get; set; }

	/// <summary>
	/// <para>
	/// A regular expression that is used to search for values that match the category.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Regex { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ResultType { get; set; }

	/// <summary>
	/// <para>
	/// A space separated list of the common tokens that are matched in values of the category.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Terms { get; set; }
}