// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class CategoryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.Category>
{
	private static readonly System.Text.Json.JsonEncodedText PropCategoryId = System.Text.Json.JsonEncodedText.Encode("category_id");
	private static readonly System.Text.Json.JsonEncodedText PropExamples = System.Text.Json.JsonEncodedText.Encode("examples");
	private static readonly System.Text.Json.JsonEncodedText PropGrokPattern = System.Text.Json.JsonEncodedText.Encode("grok_pattern");
	private static readonly System.Text.Json.JsonEncodedText PropJobId = System.Text.Json.JsonEncodedText.Encode("job_id");
	private static readonly System.Text.Json.JsonEncodedText PropMaxMatchingLength = System.Text.Json.JsonEncodedText.Encode("max_matching_length");
	private static readonly System.Text.Json.JsonEncodedText PropMlcategory = System.Text.Json.JsonEncodedText.Encode("mlcategory");
	private static readonly System.Text.Json.JsonEncodedText PropNumMatches = System.Text.Json.JsonEncodedText.Encode("num_matches");
	private static readonly System.Text.Json.JsonEncodedText PropP = System.Text.Json.JsonEncodedText.Encode("p");
	private static readonly System.Text.Json.JsonEncodedText PropPartitionFieldName = System.Text.Json.JsonEncodedText.Encode("partition_field_name");
	private static readonly System.Text.Json.JsonEncodedText PropPartitionFieldValue = System.Text.Json.JsonEncodedText.Encode("partition_field_value");
	private static readonly System.Text.Json.JsonEncodedText PropPreferredToCategories = System.Text.Json.JsonEncodedText.Encode("preferred_to_categories");
	private static readonly System.Text.Json.JsonEncodedText PropRegex = System.Text.Json.JsonEncodedText.Encode("regex");
	private static readonly System.Text.Json.JsonEncodedText PropResultType = System.Text.Json.JsonEncodedText.Encode("result_type");
	private static readonly System.Text.Json.JsonEncodedText PropTerms = System.Text.Json.JsonEncodedText.Encode("terms");

	public override Elastic.Clients.Elasticsearch.MachineLearning.Category Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propCategoryId = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propExamples = default;
		LocalJsonValue<string?> propGrokPattern = default;
		LocalJsonValue<string> propJobId = default;
		LocalJsonValue<long> propMaxMatchingLength = default;
		LocalJsonValue<string> propMlcategory = default;
		LocalJsonValue<long?> propNumMatches = default;
		LocalJsonValue<string?> propP = default;
		LocalJsonValue<string?> propPartitionFieldName = default;
		LocalJsonValue<string?> propPartitionFieldValue = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>?> propPreferredToCategories = default;
		LocalJsonValue<string> propRegex = default;
		LocalJsonValue<string> propResultType = default;
		LocalJsonValue<string> propTerms = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCategoryId.TryReadProperty(ref reader, options, PropCategoryId, null))
			{
				continue;
			}

			if (propExamples.TryReadProperty(ref reader, options, PropExamples, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propGrokPattern.TryReadProperty(ref reader, options, PropGrokPattern, null))
			{
				continue;
			}

			if (propJobId.TryReadProperty(ref reader, options, PropJobId, null))
			{
				continue;
			}

			if (propMaxMatchingLength.TryReadProperty(ref reader, options, PropMaxMatchingLength, null))
			{
				continue;
			}

			if (propMlcategory.TryReadProperty(ref reader, options, PropMlcategory, null))
			{
				continue;
			}

			if (propNumMatches.TryReadProperty(ref reader, options, PropNumMatches, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propP.TryReadProperty(ref reader, options, PropP, null))
			{
				continue;
			}

			if (propPartitionFieldName.TryReadProperty(ref reader, options, PropPartitionFieldName, null))
			{
				continue;
			}

			if (propPartitionFieldValue.TryReadProperty(ref reader, options, PropPartitionFieldValue, null))
			{
				continue;
			}

			if (propPreferredToCategories.TryReadProperty(ref reader, options, PropPreferredToCategories, static System.Collections.Generic.IReadOnlyCollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propRegex.TryReadProperty(ref reader, options, PropRegex, null))
			{
				continue;
			}

			if (propResultType.TryReadProperty(ref reader, options, PropResultType, null))
			{
				continue;
			}

			if (propTerms.TryReadProperty(ref reader, options, PropTerms, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.Category(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			CategoryId = propCategoryId.Value,
			Examples = propExamples.Value,
			GrokPattern = propGrokPattern.Value,
			JobId = propJobId.Value,
			MaxMatchingLength = propMaxMatchingLength.Value,
			Mlcategory = propMlcategory.Value,
			NumMatches = propNumMatches.Value,
			P = propP.Value,
			PartitionFieldName = propPartitionFieldName.Value,
			PartitionFieldValue = propPartitionFieldValue.Value,
			PreferredToCategories = propPreferredToCategories.Value,
			Regex = propRegex.Value,
			ResultType = propResultType.Value,
			Terms = propTerms.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.Category value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCategoryId, value.CategoryId, null, null);
		writer.WriteProperty(options, PropExamples, value.Examples, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropGrokPattern, value.GrokPattern, null, null);
		writer.WriteProperty(options, PropJobId, value.JobId, null, null);
		writer.WriteProperty(options, PropMaxMatchingLength, value.MaxMatchingLength, null, null);
		writer.WriteProperty(options, PropMlcategory, value.Mlcategory, null, null);
		writer.WriteProperty(options, PropNumMatches, value.NumMatches, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropP, value.P, null, null);
		writer.WriteProperty(options, PropPartitionFieldName, value.PartitionFieldName, null, null);
		writer.WriteProperty(options, PropPartitionFieldValue, value.PartitionFieldValue, null, null);
		writer.WriteProperty(options, PropPreferredToCategories, value.PreferredToCategories, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropRegex, value.Regex, null, null);
		writer.WriteProperty(options, PropResultType, value.ResultType, null, null);
		writer.WriteProperty(options, PropTerms, value.Terms, null, null);
		writer.WriteEndObject();
	}
}