// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class CategorizationStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberOk = System.Text.Json.JsonEncodedText.Encode("ok");
	private static readonly System.Text.Json.JsonEncodedText MemberWarn = System.Text.Json.JsonEncodedText.Encode("warn");

	public override Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberOk))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus.Ok;
		}

		if (reader.ValueTextEquals(MemberWarn))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus.Warn;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberOk.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus.Ok;
		}

		if (string.Equals(value, MemberWarn.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus.Warn;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus.Ok:
				writer.WriteStringValue(MemberOk);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus.Warn:
				writer.WriteStringValue(MemberWarn);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.CategorizationStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}