// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.CategorizationAnalyzerDefinitionConverter))]
public sealed partial class CategorizationAnalyzerDefinition
{
#if NET7_0_OR_GREATER
	public CategorizationAnalyzerDefinition()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CategorizationAnalyzerDefinition()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CategorizationAnalyzerDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// One or more character filters. In addition to the built-in character filters, other plugins can provide more character filters. If this property is not specified, no character filters are applied prior to categorization. If you are customizing some other aspect of the analyzer and you need to achieve the equivalent of <c>categorization_filters</c> (which are not permitted when some other aspect of the analyzer is customized), add them here as pattern replace character filters.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>? CharFilter { get; set; }

	/// <summary>
	/// <para>
	/// One or more token filters. In addition to the built-in token filters, other plugins can provide more token filters. If this property is not specified, no token filters are applied prior to categorization.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// The name or definition of the tokenizer to use after character filters are applied. This property is compulsory if <c>categorization_analyzer</c> is specified as an object. Machine learning provides a tokenizer called <c>ml_standard</c> that tokenizes in a way that has been determined to produce good categorization results on a variety of log file formats for logs in English. If you want to use that tokenizer but change the character or token filters, specify "tokenizer": "ml_standard" in your <c>categorization_analyzer</c>. Additionally, the <c>ml_classic</c> tokenizer is available, which tokenizes in the same way as the non-customizable tokenizer in old versions of the product (before 6.2). <c>ml_classic</c> was the default categorization tokenizer in versions 6.2 to 7.13, so if you need categorization identical to the default for jobs created in these versions, specify "tokenizer": "ml_classic" in your <c>categorization_analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer? Tokenizer { get; set; }
}

public readonly partial struct CategorizationAnalyzerDefinitionDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CategorizationAnalyzerDefinitionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CategorizationAnalyzerDefinitionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition instance) => new Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// One or more character filters. In addition to the built-in character filters, other plugins can provide more character filters. If this property is not specified, no character filters are applied prior to categorization. If you are customizing some other aspect of the analyzer and you need to achieve the equivalent of <c>categorization_filters</c> (which are not permitted when some other aspect of the analyzer is customized), add them here as pattern replace character filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor CharFilter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>? value)
	{
		Instance.CharFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more character filters. In addition to the built-in character filters, other plugins can provide more character filters. If this property is not specified, no character filters are applied prior to categorization. If you are customizing some other aspect of the analyzer and you need to achieve the equivalent of <c>categorization_filters</c> (which are not permitted when some other aspect of the analyzer is customized), add them here as pattern replace character filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor CharFilter(params Elastic.Clients.Elasticsearch.Analysis.ICharFilter[] values)
	{
		Instance.CharFilter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more character filters. In addition to the built-in character filters, other plugins can provide more character filters. If this property is not specified, no character filters are applied prior to categorization. If you are customizing some other aspect of the analyzer and you need to achieve the equivalent of <c>categorization_filters</c> (which are not permitted when some other aspect of the analyzer is customized), add them here as pattern replace character filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor CharFilter(params System.Func<Elastic.Clients.Elasticsearch.Analysis.CharFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ICharFilter>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Analysis.CharFilterFactory.Build(action));
		}

		Instance.CharFilter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more token filters. In addition to the built-in token filters, other plugins can provide more token filters. If this property is not specified, no token filters are applied prior to categorization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more token filters. In addition to the built-in token filters, other plugins can provide more token filters. If this property is not specified, no token filters are applied prior to categorization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor Filter(params Elastic.Clients.Elasticsearch.Analysis.ITokenFilter[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more token filters. In addition to the built-in token filters, other plugins can provide more token filters. If this property is not specified, no token filters are applied prior to categorization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor Filter(params System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name or definition of the tokenizer to use after character filters are applied. This property is compulsory if <c>categorization_analyzer</c> is specified as an object. Machine learning provides a tokenizer called <c>ml_standard</c> that tokenizes in a way that has been determined to produce good categorization results on a variety of log file formats for logs in English. If you want to use that tokenizer but change the character or token filters, specify "tokenizer": "ml_standard" in your <c>categorization_analyzer</c>. Additionally, the <c>ml_classic</c> tokenizer is available, which tokenizes in the same way as the non-customizable tokenizer in old versions of the product (before 6.2). <c>ml_classic</c> was the default categorization tokenizer in versions 6.2 to 7.13, so if you need categorization identical to the default for jobs created in these versions, specify "tokenizer": "ml_classic" in your <c>categorization_analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor Tokenizer(Elastic.Clients.Elasticsearch.Analysis.ITokenizer? value)
	{
		Instance.Tokenizer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name or definition of the tokenizer to use after character filters are applied. This property is compulsory if <c>categorization_analyzer</c> is specified as an object. Machine learning provides a tokenizer called <c>ml_standard</c> that tokenizes in a way that has been determined to produce good categorization results on a variety of log file formats for logs in English. If you want to use that tokenizer but change the character or token filters, specify "tokenizer": "ml_standard" in your <c>categorization_analyzer</c>. Additionally, the <c>ml_classic</c> tokenizer is available, which tokenizes in the same way as the non-customizable tokenizer in old versions of the product (before 6.2). <c>ml_classic</c> was the default categorization tokenizer in versions 6.2 to 7.13, so if you need categorization identical to the default for jobs created in these versions, specify "tokenizer": "ml_classic" in your <c>categorization_analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor Tokenizer(System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenizer> action)
	{
		Instance.Tokenizer = Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinitionDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}