// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.CalendarEventConverter))]
public sealed partial class CalendarEvent
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CalendarEvent(string description, System.DateTimeOffset endTime, System.DateTimeOffset startTime)
	{
		Description = description;
		EndTime = endTime;
		StartTime = startTime;
	}
#if NET7_0_OR_GREATER
	public CalendarEvent()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CalendarEvent()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CalendarEvent(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A string that uniquely identifies a calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? CalendarId { get; set; }

	/// <summary>
	/// <para>
	/// A description of the scheduled event.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Description { get; set; }

	/// <summary>
	/// <para>
	/// The timestamp for the end of the scheduled event in milliseconds since the epoch or ISO 8601 format.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset EndTime { get; set; }
	public Elastic.Clients.Elasticsearch.Id? EventId { get; set; }

	/// <summary>
	/// <para>
	/// Shift time by this many seconds. For example adjust time for daylight savings changes
	/// </para>
	/// </summary>
	public int? ForceTimeShift { get; set; }

	/// <summary>
	/// <para>
	/// When true the model will not be updated for this calendar period.
	/// </para>
	/// </summary>
	public bool? SkipModelUpdate { get; set; }

	/// <summary>
	/// <para>
	/// When true the model will not create results for this calendar period.
	/// </para>
	/// </summary>
	public bool? SkipResult { get; set; }

	/// <summary>
	/// <para>
	/// The timestamp for the beginning of the scheduled event in milliseconds since the epoch or ISO 8601 format.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset StartTime { get; set; }
}

public readonly partial struct CalendarEventDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CalendarEventDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CalendarEventDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent instance) => new Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent(Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A string that uniquely identifies a calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor CalendarId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.CalendarId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the scheduled event.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor Description(string value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The timestamp for the end of the scheduled event in milliseconds since the epoch or ISO 8601 format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor EndTime(System.DateTimeOffset value)
	{
		Instance.EndTime = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor EventId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.EventId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Shift time by this many seconds. For example adjust time for daylight savings changes
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor ForceTimeShift(int? value)
	{
		Instance.ForceTimeShift = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When true the model will not be updated for this calendar period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor SkipModelUpdate(bool? value = true)
	{
		Instance.SkipModelUpdate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When true the model will not create results for this calendar period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor SkipResult(bool? value = true)
	{
		Instance.SkipResult = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The timestamp for the beginning of the scheduled event in milliseconds since the epoch or ISO 8601 format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor StartTime(System.DateTimeOffset value)
	{
		Instance.StartTime = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.CalendarEventDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.CalendarEvent(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}