// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.BucketSummaryConverter))]
public sealed partial class BucketSummary
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketSummary(double anomalyScore, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.BucketInfluencer> bucketInfluencers, System.TimeSpan bucketSpan, long eventCount, double initialAnomalyScore, bool isInterim, string jobId, System.TimeSpan processingTimeMs, string resultType, System.DateTimeOffset timestamp)
	{
		AnomalyScore = anomalyScore;
		BucketInfluencers = bucketInfluencers;
		BucketSpan = bucketSpan;
		EventCount = eventCount;
		InitialAnomalyScore = initialAnomalyScore;
		IsInterim = isInterim;
		JobId = jobId;
		ProcessingTimeMs = processingTimeMs;
		ResultType = resultType;
		Timestamp = timestamp;
	}
#if NET7_0_OR_GREATER
	public BucketSummary()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BucketSummary()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BucketSummary(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum anomaly score, between 0-100, for any of the bucket influencers. This is an overall, rate-limited
	/// score for the job. All the anomaly records in the bucket contribute to this score. This value might be updated as
	/// new data is analyzed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double AnomalyScore { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.BucketInfluencer> BucketInfluencers { get; set; }

	/// <summary>
	/// <para>
	/// The length of the bucket in seconds. This value matches the bucket span that is specified in the job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan BucketSpan { get; set; }

	/// <summary>
	/// <para>
	/// The number of input data records processed in this bucket.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long EventCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum anomaly score for any of the bucket influencers. This is the initial value that was calculated at the
	/// time the bucket was processed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double InitialAnomalyScore { get; set; }

	/// <summary>
	/// <para>
	/// If true, this is an interim result. In other words, the results are calculated based on partial input data.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IsInterim { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// The amount of time, in milliseconds, that it took to analyze the bucket contents and calculate results.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ProcessingTimeMs { get; set; }

	/// <summary>
	/// <para>
	/// Internal. This value is always set to bucket.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ResultType { get; set; }

	/// <summary>
	/// <para>
	/// The start time of the bucket. This timestamp uniquely identifies the bucket. Events that occur exactly at the
	/// timestamp of the bucket are included in the results for the bucket.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset Timestamp { get; set; }

	/// <summary>
	/// <para>
	/// The start time of the bucket. This timestamp uniquely identifies the bucket. Events that occur exactly at the
	/// timestamp of the bucket are included in the results for the bucket.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? TimestampString { get; set; }
}