// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class AppliesToConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo>
{
	private static readonly System.Text.Json.JsonEncodedText MemberActual = System.Text.Json.JsonEncodedText.Encode("actual");
	private static readonly System.Text.Json.JsonEncodedText MemberDiffFromTypical = System.Text.Json.JsonEncodedText.Encode("diff_from_typical");
	private static readonly System.Text.Json.JsonEncodedText MemberTime = System.Text.Json.JsonEncodedText.Encode("time");
	private static readonly System.Text.Json.JsonEncodedText MemberTypical = System.Text.Json.JsonEncodedText.Encode("typical");

	public override Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberActual))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Actual;
		}

		if (reader.ValueTextEquals(MemberDiffFromTypical))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.DiffFromTypical;
		}

		if (reader.ValueTextEquals(MemberTime))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Time;
		}

		if (reader.ValueTextEquals(MemberTypical))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Typical;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberActual.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Actual;
		}

		if (string.Equals(value, MemberDiffFromTypical.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.DiffFromTypical;
		}

		if (string.Equals(value, MemberTime.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Time;
		}

		if (string.Equals(value, MemberTypical.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Typical;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Actual:
				writer.WriteStringValue(MemberActual);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.DiffFromTypical:
				writer.WriteStringValue(MemberDiffFromTypical);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Time:
				writer.WriteStringValue(MemberTime);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo.Typical:
				writer.WriteStringValue(MemberTypical);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}