// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.AnomalyExplanationConverter))]
public sealed partial class AnomalyExplanation
{
#if NET7_0_OR_GREATER
	public AnomalyExplanation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AnomalyExplanation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AnomalyExplanation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Impact from the duration and magnitude of the detected anomaly relative to the historical average.
	/// </para>
	/// </summary>
	public int? AnomalyCharacteristicsImpact { get; set; }

	/// <summary>
	/// <para>
	/// Length of the detected anomaly in the number of buckets.
	/// </para>
	/// </summary>
	public int? AnomalyLength { get; set; }

	/// <summary>
	/// <para>
	/// Type of the detected anomaly: <c>spike</c> or <c>dip</c>.
	/// </para>
	/// </summary>
	public string? AnomalyType { get; set; }

	/// <summary>
	/// <para>
	/// Indicates reduction of anomaly score for the bucket with large confidence intervals. If a bucket has large confidence intervals, the score is reduced.
	/// </para>
	/// </summary>
	public bool? HighVariancePenalty { get; set; }

	/// <summary>
	/// <para>
	/// If the bucket contains fewer samples than expected, the score is reduced.
	/// </para>
	/// </summary>
	public bool? IncompleteBucketPenalty { get; set; }

	/// <summary>
	/// <para>
	/// Lower bound of the 95% confidence interval.
	/// </para>
	/// </summary>
	public double? LowerConfidenceBound { get; set; }

	/// <summary>
	/// <para>
	/// Impact of the deviation between actual and typical values in the past 12 buckets.
	/// </para>
	/// </summary>
	public int? MultiBucketImpact { get; set; }

	/// <summary>
	/// <para>
	/// Impact of the deviation between actual and typical values in the current bucket.
	/// </para>
	/// </summary>
	public int? SingleBucketImpact { get; set; }

	/// <summary>
	/// <para>
	/// Typical (expected) value for this bucket.
	/// </para>
	/// </summary>
	public double? TypicalValue { get; set; }

	/// <summary>
	/// <para>
	/// Upper bound of the 95% confidence interval.
	/// </para>
	/// </summary>
	public double? UpperConfidenceBound { get; set; }
}