// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class AnomalyExplanationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.AnomalyExplanation>
{
	private static readonly System.Text.Json.JsonEncodedText PropAnomalyCharacteristicsImpact = System.Text.Json.JsonEncodedText.Encode("anomaly_characteristics_impact");
	private static readonly System.Text.Json.JsonEncodedText PropAnomalyLength = System.Text.Json.JsonEncodedText.Encode("anomaly_length");
	private static readonly System.Text.Json.JsonEncodedText PropAnomalyType = System.Text.Json.JsonEncodedText.Encode("anomaly_type");
	private static readonly System.Text.Json.JsonEncodedText PropHighVariancePenalty = System.Text.Json.JsonEncodedText.Encode("high_variance_penalty");
	private static readonly System.Text.Json.JsonEncodedText PropIncompleteBucketPenalty = System.Text.Json.JsonEncodedText.Encode("incomplete_bucket_penalty");
	private static readonly System.Text.Json.JsonEncodedText PropLowerConfidenceBound = System.Text.Json.JsonEncodedText.Encode("lower_confidence_bound");
	private static readonly System.Text.Json.JsonEncodedText PropMultiBucketImpact = System.Text.Json.JsonEncodedText.Encode("multi_bucket_impact");
	private static readonly System.Text.Json.JsonEncodedText PropSingleBucketImpact = System.Text.Json.JsonEncodedText.Encode("single_bucket_impact");
	private static readonly System.Text.Json.JsonEncodedText PropTypicalValue = System.Text.Json.JsonEncodedText.Encode("typical_value");
	private static readonly System.Text.Json.JsonEncodedText PropUpperConfidenceBound = System.Text.Json.JsonEncodedText.Encode("upper_confidence_bound");

	public override Elastic.Clients.Elasticsearch.MachineLearning.AnomalyExplanation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int?> propAnomalyCharacteristicsImpact = default;
		LocalJsonValue<int?> propAnomalyLength = default;
		LocalJsonValue<string?> propAnomalyType = default;
		LocalJsonValue<bool?> propHighVariancePenalty = default;
		LocalJsonValue<bool?> propIncompleteBucketPenalty = default;
		LocalJsonValue<double?> propLowerConfidenceBound = default;
		LocalJsonValue<int?> propMultiBucketImpact = default;
		LocalJsonValue<int?> propSingleBucketImpact = default;
		LocalJsonValue<double?> propTypicalValue = default;
		LocalJsonValue<double?> propUpperConfidenceBound = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAnomalyCharacteristicsImpact.TryReadProperty(ref reader, options, PropAnomalyCharacteristicsImpact, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propAnomalyLength.TryReadProperty(ref reader, options, PropAnomalyLength, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propAnomalyType.TryReadProperty(ref reader, options, PropAnomalyType, null))
			{
				continue;
			}

			if (propHighVariancePenalty.TryReadProperty(ref reader, options, PropHighVariancePenalty, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propIncompleteBucketPenalty.TryReadProperty(ref reader, options, PropIncompleteBucketPenalty, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propLowerConfidenceBound.TryReadProperty(ref reader, options, PropLowerConfidenceBound, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propMultiBucketImpact.TryReadProperty(ref reader, options, PropMultiBucketImpact, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSingleBucketImpact.TryReadProperty(ref reader, options, PropSingleBucketImpact, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTypicalValue.TryReadProperty(ref reader, options, PropTypicalValue, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propUpperConfidenceBound.TryReadProperty(ref reader, options, PropUpperConfidenceBound, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.AnomalyExplanation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AnomalyCharacteristicsImpact = propAnomalyCharacteristicsImpact.Value,
			AnomalyLength = propAnomalyLength.Value,
			AnomalyType = propAnomalyType.Value,
			HighVariancePenalty = propHighVariancePenalty.Value,
			IncompleteBucketPenalty = propIncompleteBucketPenalty.Value,
			LowerConfidenceBound = propLowerConfidenceBound.Value,
			MultiBucketImpact = propMultiBucketImpact.Value,
			SingleBucketImpact = propSingleBucketImpact.Value,
			TypicalValue = propTypicalValue.Value,
			UpperConfidenceBound = propUpperConfidenceBound.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.AnomalyExplanation value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAnomalyCharacteristicsImpact, value.AnomalyCharacteristicsImpact, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropAnomalyLength, value.AnomalyLength, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropAnomalyType, value.AnomalyType, null, null);
		writer.WriteProperty(options, PropHighVariancePenalty, value.HighVariancePenalty, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropIncompleteBucketPenalty, value.IncompleteBucketPenalty, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropLowerConfidenceBound, value.LowerConfidenceBound, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropMultiBucketImpact, value.MultiBucketImpact, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSingleBucketImpact, value.SingleBucketImpact, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTypicalValue, value.TypicalValue, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropUpperConfidenceBound, value.UpperConfidenceBound, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteEndObject();
	}
}