// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.AnomalyConverter))]
public sealed partial class Anomaly
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Anomaly(System.TimeSpan bucketSpan, int detectorIndex, double initialRecordScore, bool isInterim, string jobId, double probability, double recordScore, string resultType, System.DateTimeOffset timestamp)
	{
		BucketSpan = bucketSpan;
		DetectorIndex = detectorIndex;
		InitialRecordScore = initialRecordScore;
		IsInterim = isInterim;
		JobId = jobId;
		Probability = probability;
		RecordScore = recordScore;
		ResultType = resultType;
		Timestamp = timestamp;
	}
#if NET7_0_OR_GREATER
	public Anomaly()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Anomaly()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Anomaly(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The actual value for the bucket.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<double>? Actual { get; set; }

	/// <summary>
	/// <para>
	/// Information about the factors impacting the initial anomaly score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnomalyExplanation? AnomalyScoreExplanation { get; set; }

	/// <summary>
	/// <para>
	/// The length of the bucket in seconds. This value matches the <c>bucket_span</c> that is specified in the job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan BucketSpan { get; set; }

	/// <summary>
	/// <para>
	/// The field used to split the data. In particular, this property is used for analyzing the splits with respect to their own history. It is used for finding unusual values in the context of the split.
	/// </para>
	/// </summary>
	public string? ByFieldName { get; set; }

	/// <summary>
	/// <para>
	/// The value of <c>by_field_name</c>.
	/// </para>
	/// </summary>
	public string? ByFieldValue { get; set; }

	/// <summary>
	/// <para>
	/// For population analysis, an over field must be specified in the detector. This property contains an array of anomaly records that are the causes for the anomaly that has been identified for the over field. This sub-resource contains the most anomalous records for the <c>over_field_name</c>. For scalability reasons, a maximum of the 10 most significant causes of the anomaly are returned. As part of the core analytical modeling, these low-level anomaly records are aggregated for their parent over field record. The <c>causes</c> resource contains similar elements to the record resource, namely <c>actual</c>, <c>typical</c>, <c>geo_results.actual_point</c>, <c>geo_results.typical_point</c>, <c>*_field_name</c> and <c>*_field_value</c>. Probability and scores are not applicable to causes.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.AnomalyCause>? Causes { get; set; }

	/// <summary>
	/// <para>
	/// A unique identifier for the detector.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int DetectorIndex { get; set; }

	/// <summary>
	/// <para>
	/// Certain functions require a field to operate on, for example, <c>sum()</c>. For those functions, this value is the name of the field to be analyzed.
	/// </para>
	/// </summary>
	public string? FieldName { get; set; }

	/// <summary>
	/// <para>
	/// The function in which the anomaly occurs, as specified in the detector configuration. For example, <c>max</c>.
	/// </para>
	/// </summary>
	public string? Function { get; set; }

	/// <summary>
	/// <para>
	/// The description of the function in which the anomaly occurs, as specified in the detector configuration.
	/// </para>
	/// </summary>
	public string? FunctionDescription { get; set; }

	/// <summary>
	/// <para>
	/// If the detector function is <c>lat_long</c>, this object contains comma delimited strings for the latitude and longitude of the actual and typical values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GeoResults? GeoResults { get; set; }

	/// <summary>
	/// <para>
	/// If influencers were specified in the detector configuration, this array contains influencers that contributed to or were to blame for an anomaly.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.Influence>? Influencers { get; set; }

	/// <summary>
	/// <para>
	/// A normalized score between 0-100, which is based on the probability of the anomalousness of this record. This is the initial value that was calculated at the time the bucket was processed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double InitialRecordScore { get; set; }

	/// <summary>
	/// <para>
	/// If true, this is an interim result. In other words, the results are calculated based on partial input data.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IsInterim { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// The field used to split the data. In particular, this property is used for analyzing the splits with respect to the history of all splits. It is used for finding unusual values in the population of all splits.
	/// </para>
	/// </summary>
	public string? OverFieldName { get; set; }

	/// <summary>
	/// <para>
	/// The value of <c>over_field_name</c>.
	/// </para>
	/// </summary>
	public string? OverFieldValue { get; set; }

	/// <summary>
	/// <para>
	/// The field used to segment the analysis. When you use this property, you have completely independent baselines for each value of this field.
	/// </para>
	/// </summary>
	public string? PartitionFieldName { get; set; }

	/// <summary>
	/// <para>
	/// The value of <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public string? PartitionFieldValue { get; set; }

	/// <summary>
	/// <para>
	/// The probability of the individual anomaly occurring, in the range 0 to 1. For example, <c>0.0000772031</c>. This value can be held to a high precision of over 300 decimal places, so the <c>record_score</c> is provided as a human-readable and friendly interpretation of this.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double Probability { get; set; }

	/// <summary>
	/// <para>
	/// A normalized score between 0-100, which is based on the probability of the anomalousness of this record. Unlike <c>initial_record_score</c>, this value will be updated by a re-normalization process as new data is analyzed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double RecordScore { get; set; }

	/// <summary>
	/// <para>
	/// Internal. This is always set to <c>record</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ResultType { get; set; }

	/// <summary>
	/// <para>
	/// The start time of the bucket for which these results were calculated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset Timestamp { get; set; }

	/// <summary>
	/// <para>
	/// The typical value for the bucket, according to analytical modeling.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<double>? Typical { get; set; }
}