// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.AnalysisLimitsConverter))]
public sealed partial class AnalysisLimits
{
#if NET7_0_OR_GREATER
	public AnalysisLimits()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AnalysisLimits()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AnalysisLimits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum number of examples stored per category in memory and in the results data store. If you increase this value, more examples are available, however it requires that you have more storage available. If you set this value to 0, no examples are stored. NOTE: The <c>categorization_examples_limit</c> applies only to analysis that uses categorization.
	/// </para>
	/// </summary>
	public long? CategorizationExamplesLimit { get; set; }

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are required for analytical processing. Once this limit is approached, data pruning becomes more aggressive. Upon exceeding this limit, new entities are not modeled. If the <c>xpack.ml.max_model_memory_limit</c> setting has a value greater than 0 and less than 1024mb, that value is used instead of the default. The default value is relatively small to ensure that high resource usage is a conscious decision. If you have jobs that are expected to analyze high cardinality fields, you will likely need to use a higher value. If you specify a number instead of a string, the units are assumed to be MiB. Specifying a string is recommended for clarity. If you specify a byte size unit of <c>b</c> or <c>kb</c> and the number does not equate to a discrete number of megabytes, it is rounded down to the closest MiB. The minimum valid value is 1 MiB. If you specify a value less than 1 MiB, an error occurs. If you specify a value for the <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try to create jobs that have <c>model_memory_limit</c> values greater than that setting value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? ModelMemoryLimit { get; set; }
}

public readonly partial struct AnalysisLimitsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisLimitsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisLimitsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits instance) => new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum number of examples stored per category in memory and in the results data store. If you increase this value, more examples are available, however it requires that you have more storage available. If you set this value to 0, no examples are stored. NOTE: The <c>categorization_examples_limit</c> applies only to analysis that uses categorization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor CategorizationExamplesLimit(long? value)
	{
		Instance.CategorizationExamplesLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are required for analytical processing. Once this limit is approached, data pruning becomes more aggressive. Upon exceeding this limit, new entities are not modeled. If the <c>xpack.ml.max_model_memory_limit</c> setting has a value greater than 0 and less than 1024mb, that value is used instead of the default. The default value is relatively small to ensure that high resource usage is a conscious decision. If you have jobs that are expected to analyze high cardinality fields, you will likely need to use a higher value. If you specify a number instead of a string, the units are assumed to be MiB. Specifying a string is recommended for clarity. If you specify a byte size unit of <c>b</c> or <c>kb</c> and the number does not equate to a discrete number of megabytes, it is rounded down to the closest MiB. The minimum valid value is 1 MiB. If you specify a value less than 1 MiB, an error occurs. If you specify a value for the <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try to create jobs that have <c>model_memory_limit</c> values greater than that setting value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor ModelMemoryLimit(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.ModelMemoryLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are required for analytical processing. Once this limit is approached, data pruning becomes more aggressive. Upon exceeding this limit, new entities are not modeled. If the <c>xpack.ml.max_model_memory_limit</c> setting has a value greater than 0 and less than 1024mb, that value is used instead of the default. The default value is relatively small to ensure that high resource usage is a conscious decision. If you have jobs that are expected to analyze high cardinality fields, you will likely need to use a higher value. If you specify a number instead of a string, the units are assumed to be MiB. Specifying a string is recommended for clarity. If you specify a byte size unit of <c>b</c> or <c>kb</c> and the number does not equate to a discrete number of megabytes, it is rounded down to the closest MiB. The minimum valid value is 1 MiB. If you specify a value less than 1 MiB, an error occurs. If you specify a value for the <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try to create jobs that have <c>model_memory_limit</c> values greater than that setting value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor ModelMemoryLimit(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.ModelMemoryLimit = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimitsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}