// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class AnalysisConfigReadConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigRead>
{
	private static readonly System.Text.Json.JsonEncodedText PropBucketSpan = System.Text.Json.JsonEncodedText.Encode("bucket_span");
	private static readonly System.Text.Json.JsonEncodedText PropCategorizationAnalyzer = System.Text.Json.JsonEncodedText.Encode("categorization_analyzer");
	private static readonly System.Text.Json.JsonEncodedText PropCategorizationFieldName = System.Text.Json.JsonEncodedText.Encode("categorization_field_name");
	private static readonly System.Text.Json.JsonEncodedText PropCategorizationFilters = System.Text.Json.JsonEncodedText.Encode("categorization_filters");
	private static readonly System.Text.Json.JsonEncodedText PropDetectors = System.Text.Json.JsonEncodedText.Encode("detectors");
	private static readonly System.Text.Json.JsonEncodedText PropInfluencers = System.Text.Json.JsonEncodedText.Encode("influencers");
	private static readonly System.Text.Json.JsonEncodedText PropLatency = System.Text.Json.JsonEncodedText.Encode("latency");
	private static readonly System.Text.Json.JsonEncodedText PropModelPruneWindow = System.Text.Json.JsonEncodedText.Encode("model_prune_window");
	private static readonly System.Text.Json.JsonEncodedText PropMultivariateByFields = System.Text.Json.JsonEncodedText.Encode("multivariate_by_fields");
	private static readonly System.Text.Json.JsonEncodedText PropPerPartitionCategorization = System.Text.Json.JsonEncodedText.Encode("per_partition_categorization");
	private static readonly System.Text.Json.JsonEncodedText PropSummaryCountFieldName = System.Text.Json.JsonEncodedText.Encode("summary_count_field_name");

	public override Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigRead Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propBucketSpan = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzer?> propCategorizationAnalyzer = default;
		LocalJsonValue<string?> propCategorizationFieldName = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>?> propCategorizationFilters = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead>> propDetectors = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Fields> propInfluencers = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propLatency = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propModelPruneWindow = default;
		LocalJsonValue<bool?> propMultivariateByFields = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization?> propPerPartitionCategorization = default;
		LocalJsonValue<string?> propSummaryCountFieldName = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBucketSpan.TryReadProperty(ref reader, options, PropBucketSpan, null))
			{
				continue;
			}

			if (propCategorizationAnalyzer.TryReadProperty(ref reader, options, PropCategorizationAnalyzer, null))
			{
				continue;
			}

			if (propCategorizationFieldName.TryReadProperty(ref reader, options, PropCategorizationFieldName, null))
			{
				continue;
			}

			if (propCategorizationFilters.TryReadProperty(ref reader, options, PropCategorizationFilters, static System.Collections.Generic.IReadOnlyCollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propDetectors.TryReadProperty(ref reader, options, PropDetectors, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead>(o, null)!))
			{
				continue;
			}

			if (propInfluencers.TryReadProperty(ref reader, options, PropInfluencers, null))
			{
				continue;
			}

			if (propLatency.TryReadProperty(ref reader, options, PropLatency, null))
			{
				continue;
			}

			if (propModelPruneWindow.TryReadProperty(ref reader, options, PropModelPruneWindow, null))
			{
				continue;
			}

			if (propMultivariateByFields.TryReadProperty(ref reader, options, PropMultivariateByFields, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propPerPartitionCategorization.TryReadProperty(ref reader, options, PropPerPartitionCategorization, null))
			{
				continue;
			}

			if (propSummaryCountFieldName.TryReadProperty(ref reader, options, PropSummaryCountFieldName, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigRead(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BucketSpan = propBucketSpan.Value,
			CategorizationAnalyzer = propCategorizationAnalyzer.Value,
			CategorizationFieldName = propCategorizationFieldName.Value,
			CategorizationFilters = propCategorizationFilters.Value,
			Detectors = propDetectors.Value,
			Influencers = propInfluencers.Value,
			Latency = propLatency.Value,
			ModelPruneWindow = propModelPruneWindow.Value,
			MultivariateByFields = propMultivariateByFields.Value,
			PerPartitionCategorization = propPerPartitionCategorization.Value,
			SummaryCountFieldName = propSummaryCountFieldName.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigRead value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBucketSpan, value.BucketSpan, null, null);
		writer.WriteProperty(options, PropCategorizationAnalyzer, value.CategorizationAnalyzer, null, null);
		writer.WriteProperty(options, PropCategorizationFieldName, value.CategorizationFieldName, null, null);
		writer.WriteProperty(options, PropCategorizationFilters, value.CategorizationFilters, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropDetectors, value.Detectors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.DetectorRead>(o, v, null));
		writer.WriteProperty(options, PropInfluencers, value.Influencers, null, null);
		writer.WriteProperty(options, PropLatency, value.Latency, null, null);
		writer.WriteProperty(options, PropModelPruneWindow, value.ModelPruneWindow, null, null);
		writer.WriteProperty(options, PropMultivariateByFields, value.MultivariateByFields, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropPerPartitionCategorization, value.PerPartitionCategorization, null, null);
		writer.WriteProperty(options, PropSummaryCountFieldName, value.SummaryCountFieldName, null, null);
		writer.WriteEndObject();
	}
}