// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.AnalysisConfigConverter))]
public sealed partial class AnalysisConfig
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisConfig(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.Detector> detectors)
	{
		Detectors = detectors;
	}
#if NET7_0_OR_GREATER
	public AnalysisConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AnalysisConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AnalysisConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The size of the interval that the analysis is aggregated into, typically between <c>5m</c> and <c>1h</c>. This value should be either a whole number of days or equate to a
	/// whole number of buckets in one day. If the anomaly detection job uses a datafeed with aggregations, this value must also be divisible by the interval of the date histogram aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? BucketSpan { get; set; }

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define the analyzer that is used to interpret the categorization field. This property cannot be used at the same time as <c>categorization_filters</c>. The categorization analyzer specifies how the <c>categorization_field</c> is interpreted by the categorization process. The <c>categorization_analyzer</c> field can be specified either as a string or as an object. If it is a string, it must refer to a built-in analyzer or one added by another plugin.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzer? CategorizationAnalyzer { get; set; }

	/// <summary>
	/// <para>
	/// If this property is specified, the values of the specified field will be categorized. The resulting categories must be used in a detector by setting <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c> to the keyword <c>mlcategory</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? CategorizationFieldName { get; set; }

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define optional filters. This property expects an array of regular expressions. The expressions are used to filter out matching sequences from the categorization field values. You can use this functionality to fine tune the categorization by excluding sequences from consideration when categories are defined. For example, you can exclude SQL statements that appear in your log files. This property cannot be used at the same time as <c>categorization_analyzer</c>. If you only want to define simple regular expression filters that are applied prior to tokenization, setting this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering, use the <c>categorization_analyzer</c> property instead and include the filters as pattern_replace character filters. The effect is exactly the same.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? CategorizationFilters { get; set; }

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.Detector> Detectors { get; set; }

	/// <summary>
	/// <para>
	/// A comma separated list of influencer field names. Typically these can be the by, over, or partition fields that are used in the detector configuration. You might also want to use a field name that is not specifically named in a detector, but is available as part of the input data. When you use multiple detectors, the use of influencers is recommended as it aggregates results for each influencer entity.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Influencers { get; set; }

	/// <summary>
	/// <para>
	/// The size of the window in which to expect data that is out of time order. If you specify a non-zero value, it must be greater than or equal to one second. NOTE: Latency is applicable only when you send data by using the post data API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Latency { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Affects the pruning of models that have not been updated for the given time duration. The value must be set to a multiple of the <c>bucket_span</c>. If set too low, important information may be removed from the model. For jobs created in 8.1 and later, the default value is the greater of <c>30d</c> or 20 times <c>bucket_span</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? ModelPruneWindow { get; set; }

	/// <summary>
	/// <para>
	/// This functionality is reserved for internal use. It is not supported for use in customer environments and is not subject to the support SLA of official GA features. If set to <c>true</c>, the analysis will automatically find correlations between metrics for a given by field value and report anomalies when those correlations cease to hold. For example, suppose CPU and memory usage on host A is usually highly correlated with the same metrics on host B. Perhaps this correlation occurs because they are running a load-balanced application. If you enable this property, anomalies will be reported when, for example, CPU usage on host A is high and the value of CPU usage on host B is low. That is to say, you’ll see an anomaly when the CPU of host A is unusual given the CPU of host B. To use the <c>multivariate_by_fields</c> property, you must also specify <c>by_field_name</c> in your detector.
	/// </para>
	/// </summary>
	public bool? MultivariateByFields { get; set; }

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization? PerPartitionCategorization { get; set; }

	/// <summary>
	/// <para>
	/// If this property is specified, the data that is fed to the job is expected to be pre-summarized. This property value is the name of the field that contains the count of raw data points that have been summarized. The same <c>summary_count_field_name</c> applies to all detectors in the job. NOTE: The <c>summary_count_field_name</c> property cannot be used with the <c>metric</c> function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? SummaryCountFieldName { get; set; }
}

public readonly partial struct AnalysisConfigDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The size of the interval that the analysis is aggregated into, typically between <c>5m</c> and <c>1h</c>. This value should be either a whole number of days or equate to a
	/// whole number of buckets in one day. If the anomaly detection job uses a datafeed with aggregations, this value must also be divisible by the interval of the date histogram aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> BucketSpan(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.BucketSpan = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define the analyzer that is used to interpret the categorization field. This property cannot be used at the same time as <c>categorization_filters</c>. The categorization analyzer specifies how the <c>categorization_field</c> is interpreted by the categorization process. The <c>categorization_analyzer</c> field can be specified either as a string or as an object. If it is a string, it must refer to a built-in analyzer or one added by another plugin.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> CategorizationAnalyzer(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzer? value)
	{
		Instance.CategorizationAnalyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define the analyzer that is used to interpret the categorization field. This property cannot be used at the same time as <c>categorization_filters</c>. The categorization analyzer specifies how the <c>categorization_field</c> is interpreted by the categorization process. The <c>categorization_analyzer</c> field can be specified either as a string or as an object. If it is a string, it must refer to a built-in analyzer or one added by another plugin.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> CategorizationAnalyzer(System.Func<Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerFactory, Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzer> action)
	{
		Instance.CategorizationAnalyzer = Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the values of the specified field will be categorized. The resulting categories must be used in a detector by setting <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c> to the keyword <c>mlcategory</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> CategorizationFieldName(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.CategorizationFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the values of the specified field will be categorized. The resulting categories must be used in a detector by setting <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c> to the keyword <c>mlcategory</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> CategorizationFieldName(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.CategorizationFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define optional filters. This property expects an array of regular expressions. The expressions are used to filter out matching sequences from the categorization field values. You can use this functionality to fine tune the categorization by excluding sequences from consideration when categories are defined. For example, you can exclude SQL statements that appear in your log files. This property cannot be used at the same time as <c>categorization_analyzer</c>. If you only want to define simple regular expression filters that are applied prior to tokenization, setting this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering, use the <c>categorization_analyzer</c> property instead and include the filters as pattern_replace character filters. The effect is exactly the same.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> CategorizationFilters(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.CategorizationFilters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define optional filters. This property expects an array of regular expressions. The expressions are used to filter out matching sequences from the categorization field values. You can use this functionality to fine tune the categorization by excluding sequences from consideration when categories are defined. For example, you can exclude SQL statements that appear in your log files. This property cannot be used at the same time as <c>categorization_analyzer</c>. If you only want to define simple regular expression filters that are applied prior to tokenization, setting this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering, use the <c>categorization_analyzer</c> property instead and include the filters as pattern_replace character filters. The effect is exactly the same.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> CategorizationFilters(params string[] values)
	{
		Instance.CategorizationFilters = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> Detectors(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.Detector> value)
	{
		Instance.Detectors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> Detectors(params Elastic.Clients.Elasticsearch.MachineLearning.Detector[] values)
	{
		Instance.Detectors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> Detectors(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<TDocument>>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.Detector>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<TDocument>.Build(action));
		}

		Instance.Detectors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma separated list of influencer field names. Typically these can be the by, over, or partition fields that are used in the detector configuration. You might also want to use a field name that is not specifically named in a detector, but is available as part of the input data. When you use multiple detectors, the use of influencers is recommended as it aggregates results for each influencer entity.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> Influencers(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Influencers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma separated list of influencer field names. Typically these can be the by, over, or partition fields that are used in the detector configuration. You might also want to use a field name that is not specifically named in a detector, but is available as part of the input data. When you use multiple detectors, the use of influencers is recommended as it aggregates results for each influencer entity.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> Influencers(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Influencers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The size of the window in which to expect data that is out of time order. If you specify a non-zero value, it must be greater than or equal to one second. NOTE: Latency is applicable only when you send data by using the post data API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> Latency(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Latency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Affects the pruning of models that have not been updated for the given time duration. The value must be set to a multiple of the <c>bucket_span</c>. If set too low, important information may be removed from the model. For jobs created in 8.1 and later, the default value is the greater of <c>30d</c> or 20 times <c>bucket_span</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> ModelPruneWindow(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ModelPruneWindow = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This functionality is reserved for internal use. It is not supported for use in customer environments and is not subject to the support SLA of official GA features. If set to <c>true</c>, the analysis will automatically find correlations between metrics for a given by field value and report anomalies when those correlations cease to hold. For example, suppose CPU and memory usage on host A is usually highly correlated with the same metrics on host B. Perhaps this correlation occurs because they are running a load-balanced application. If you enable this property, anomalies will be reported when, for example, CPU usage on host A is high and the value of CPU usage on host B is low. That is to say, you’ll see an anomaly when the CPU of host A is unusual given the CPU of host B. To use the <c>multivariate_by_fields</c> property, you must also specify <c>by_field_name</c> in your detector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> MultivariateByFields(bool? value = true)
	{
		Instance.MultivariateByFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> PerPartitionCategorization(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization? value)
	{
		Instance.PerPartitionCategorization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> PerPartitionCategorization()
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> PerPartitionCategorization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor>? action)
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the data that is fed to the job is expected to be pre-summarized. This property value is the name of the field that contains the count of raw data points that have been summarized. The same <c>summary_count_field_name</c> applies to all detectors in the job. NOTE: The <c>summary_count_field_name</c> property cannot be used with the <c>metric</c> function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> SummaryCountFieldName(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.SummaryCountFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the data that is fed to the job is expected to be pre-summarized. This property value is the name of the field that contains the count of raw data points that have been summarized. The same <c>summary_count_field_name</c> applies to all detectors in the job. NOTE: The <c>summary_count_field_name</c> property cannot be used with the <c>metric</c> function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument> SummaryCountFieldName(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.SummaryCountFieldName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct AnalysisConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalysisConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The size of the interval that the analysis is aggregated into, typically between <c>5m</c> and <c>1h</c>. This value should be either a whole number of days or equate to a
	/// whole number of buckets in one day. If the anomaly detection job uses a datafeed with aggregations, this value must also be divisible by the interval of the date histogram aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor BucketSpan(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.BucketSpan = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define the analyzer that is used to interpret the categorization field. This property cannot be used at the same time as <c>categorization_filters</c>. The categorization analyzer specifies how the <c>categorization_field</c> is interpreted by the categorization process. The <c>categorization_analyzer</c> field can be specified either as a string or as an object. If it is a string, it must refer to a built-in analyzer or one added by another plugin.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor CategorizationAnalyzer(Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzer? value)
	{
		Instance.CategorizationAnalyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define the analyzer that is used to interpret the categorization field. This property cannot be used at the same time as <c>categorization_filters</c>. The categorization analyzer specifies how the <c>categorization_field</c> is interpreted by the categorization process. The <c>categorization_analyzer</c> field can be specified either as a string or as an object. If it is a string, it must refer to a built-in analyzer or one added by another plugin.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor CategorizationAnalyzer(System.Func<Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerFactory, Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzer> action)
	{
		Instance.CategorizationAnalyzer = Elastic.Clients.Elasticsearch.MachineLearning.CategorizationAnalyzerFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the values of the specified field will be categorized. The resulting categories must be used in a detector by setting <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c> to the keyword <c>mlcategory</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor CategorizationFieldName(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.CategorizationFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the values of the specified field will be categorized. The resulting categories must be used in a detector by setting <c>by_field_name</c>, <c>over_field_name</c>, or <c>partition_field_name</c> to the keyword <c>mlcategory</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor CategorizationFieldName<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.CategorizationFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define optional filters. This property expects an array of regular expressions. The expressions are used to filter out matching sequences from the categorization field values. You can use this functionality to fine tune the categorization by excluding sequences from consideration when categories are defined. For example, you can exclude SQL statements that appear in your log files. This property cannot be used at the same time as <c>categorization_analyzer</c>. If you only want to define simple regular expression filters that are applied prior to tokenization, setting this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering, use the <c>categorization_analyzer</c> property instead and include the filters as pattern_replace character filters. The effect is exactly the same.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor CategorizationFilters(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.CategorizationFilters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>categorization_field_name</c> is specified, you can also define optional filters. This property expects an array of regular expressions. The expressions are used to filter out matching sequences from the categorization field values. You can use this functionality to fine tune the categorization by excluding sequences from consideration when categories are defined. For example, you can exclude SQL statements that appear in your log files. This property cannot be used at the same time as <c>categorization_analyzer</c>. If you only want to define simple regular expression filters that are applied prior to tokenization, setting this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering, use the <c>categorization_analyzer</c> property instead and include the filters as pattern_replace character filters. The effect is exactly the same.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor CategorizationFilters(params string[] values)
	{
		Instance.CategorizationFilters = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Detectors(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.Detector> value)
	{
		Instance.Detectors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Detectors(params Elastic.Clients.Elasticsearch.MachineLearning.Detector[] values)
	{
		Instance.Detectors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Detectors(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.Detector>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor.Build(action));
		}

		Instance.Detectors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Detectors<T>(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<T>>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.Detector>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<T>.Build(action));
		}

		Instance.Detectors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma separated list of influencer field names. Typically these can be the by, over, or partition fields that are used in the detector configuration. You might also want to use a field name that is not specifically named in a detector, but is available as part of the input data. When you use multiple detectors, the use of influencers is recommended as it aggregates results for each influencer entity.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Influencers(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Influencers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma separated list of influencer field names. Typically these can be the by, over, or partition fields that are used in the detector configuration. You might also want to use a field name that is not specifically named in a detector, but is available as part of the input data. When you use multiple detectors, the use of influencers is recommended as it aggregates results for each influencer entity.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Influencers<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Influencers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The size of the window in which to expect data that is out of time order. If you specify a non-zero value, it must be greater than or equal to one second. NOTE: Latency is applicable only when you send data by using the post data API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor Latency(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Latency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Affects the pruning of models that have not been updated for the given time duration. The value must be set to a multiple of the <c>bucket_span</c>. If set too low, important information may be removed from the model. For jobs created in 8.1 and later, the default value is the greater of <c>30d</c> or 20 times <c>bucket_span</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor ModelPruneWindow(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ModelPruneWindow = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This functionality is reserved for internal use. It is not supported for use in customer environments and is not subject to the support SLA of official GA features. If set to <c>true</c>, the analysis will automatically find correlations between metrics for a given by field value and report anomalies when those correlations cease to hold. For example, suppose CPU and memory usage on host A is usually highly correlated with the same metrics on host B. Perhaps this correlation occurs because they are running a load-balanced application. If you enable this property, anomalies will be reported when, for example, CPU usage on host A is high and the value of CPU usage on host B is low. That is to say, you’ll see an anomaly when the CPU of host A is unusual given the CPU of host B. To use the <c>multivariate_by_fields</c> property, you must also specify <c>by_field_name</c> in your detector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor MultivariateByFields(bool? value = true)
	{
		Instance.MultivariateByFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor PerPartitionCategorization(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization? value)
	{
		Instance.PerPartitionCategorization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor PerPartitionCategorization()
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor PerPartitionCategorization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor>? action)
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the data that is fed to the job is expected to be pre-summarized. This property value is the name of the field that contains the count of raw data points that have been summarized. The same <c>summary_count_field_name</c> applies to all detectors in the job. NOTE: The <c>summary_count_field_name</c> property cannot be used with the <c>metric</c> function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor SummaryCountFieldName(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.SummaryCountFieldName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this property is specified, the data that is fed to the job is expected to be pre-summarized. This property value is the name of the field that contains the count of raw data points that have been summarized. The same <c>summary_count_field_name</c> applies to all detectors in the job. NOTE: The <c>summary_count_field_name</c> property cannot be used with the <c>metric</c> function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor SummaryCountFieldName<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.SummaryCountFieldName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}