// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.AggregateOutputConverter))]
public sealed partial class AggregateOutput
{
#if NET7_0_OR_GREATER
	public AggregateOutput()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AggregateOutput()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AggregateOutput(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.Weights? Exponent { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Weights? LogisticRegression { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Weights? WeightedMode { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Weights? WeightedSum { get; set; }
}

public readonly partial struct AggregateOutputDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AggregateOutputDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AggregateOutputDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput instance) => new Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput(Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor Exponent(Elastic.Clients.Elasticsearch.MachineLearning.Weights? value)
	{
		Instance.Exponent = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor Exponent(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor> action)
	{
		Instance.Exponent = Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor LogisticRegression(Elastic.Clients.Elasticsearch.MachineLearning.Weights? value)
	{
		Instance.LogisticRegression = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor LogisticRegression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor> action)
	{
		Instance.LogisticRegression = Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor WeightedMode(Elastic.Clients.Elasticsearch.MachineLearning.Weights? value)
	{
		Instance.WeightedMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor WeightedMode(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor> action)
	{
		Instance.WeightedMode = Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor WeightedSum(Elastic.Clients.Elasticsearch.MachineLearning.Weights? value)
	{
		Instance.WeightedSum = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor WeightedSum(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor> action)
	{
		Instance.WeightedSum = Elastic.Clients.Elasticsearch.MachineLearning.WeightsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}