// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.AdaptiveAllocationsSettingsConverter))]
public sealed partial class AdaptiveAllocationsSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AdaptiveAllocationsSettings(bool enabled)
	{
		Enabled = enabled;
	}
#if NET7_0_OR_GREATER
	public AdaptiveAllocationsSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AdaptiveAllocationsSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AdaptiveAllocationsSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If true, adaptive_allocations is enabled
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Enabled { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of allocations to scale to.
	/// If set, it must be greater than or equal to min_number_of_allocations.
	/// </para>
	/// </summary>
	public int? MaxNumberOfAllocations { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the minimum number of allocations to scale to.
	/// If set, it must be greater than or equal to 0.
	/// If not defined, the deployment scales to 0.
	/// </para>
	/// </summary>
	public int? MinNumberOfAllocations { get; set; }
}

public readonly partial struct AdaptiveAllocationsSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AdaptiveAllocationsSettingsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AdaptiveAllocationsSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings instance) => new Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings(Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, adaptive_allocations is enabled
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor Enabled(bool value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of allocations to scale to.
	/// If set, it must be greater than or equal to min_number_of_allocations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor MaxNumberOfAllocations(int? value)
	{
		Instance.MaxNumberOfAllocations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the minimum number of allocations to scale to.
	/// If set, it must be greater than or equal to 0.
	/// If not defined, the deployment scales to 0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor MinNumberOfAllocations(int? value)
	{
		Instance.MinNumberOfAllocations = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettingsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}